@extends('layouts.app')
@section('title', 'Sub Contracts Quote')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        
        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }
        
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }
        
        .btn-outline{
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }
        
        .btn-outline-2{
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            color: black !important;
        }
        
        .badge-primary{
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            padding:10px !important;
            font-size: 13px !important;
            font-weight: 500 !important;
        }
        
        .btn-outline i{
            color: #93D500 !important;
            font-size: 18px;
        }
        
        
        
        .btn-outline:hover{
            color: black !important;
        }
        
        .btn-outline:hover i{
            color: black !important;
        }
        
        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 15px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 15px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 70px;
            margin-bottom: 10px;
        }

        .dropzone .dz-message h3 {
            font-size: 15px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 13px;
            color: #6c757d;
        }
        
        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }
        
        .accept-btn{
            color: #008C0E !important;
            border: 1px solid #008C0E33 !important;
            background: #e5f3e7 !important;
            font-size: 15px;
        }
        
        .accept-btn i{
            color: #008C0E !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .send-link-btn{
            color: #5790FF !important;
            border: 1px solid #0048D533 !important;
            background: #eef4ff !important;
            font-size: 15px;
        }
        
        .send-link-btn i{
            color: #5790FF !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .add-item-btn{
            color: #93D500 !important;
            border: 1px solid #93D50033 !important;
            background: #f5ffe0 !important;
            font-size: 15px;
        }
        
        .add-item-btn i{
            color: #93D500 !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .img-box{
            width: 100%;
            background: #F4F4F4;
            height: 200px;
            border-radius: 8px;
            margin-bottom: 10px;
            position: relative;
        }
        
        .img-box img{
            width: 60px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        
        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            font-weight: 500;
            color: #727879;
        }
        
        
        
        .addContactBtn{
            position: absolute;
            right: -5px;
            top: -5px;
            cursor: pointer;
        }
        
        .addContactBtn .fa-plus-circle{
            font-size: 15px;
        }
        
        .green{
            border-color: #93D500 !important;
        }
        
        #kt_app_sidebar {
        display: none;
    }

    #kt_app_header {
        display: none;
    }

    #kt_app_wrapper {
        margin: 0;
    }

    </style>
    
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">

            <div class="row justify-content-center">
                <div class="col-md-8">
                   <div class="mb-5">
                        <div><img width="150px" src="{{asset('img/walker.png')}}"></div>
                        
                        <!--end::Logo-->

                    </div>
                   
                   
                    <div class="mb-5 d-flex justify-content-between align-items-center flex-wrap">
                        <div class="mb-3 mb-md-0">
                            <h1 class="mb-0">{{$customer->company_name}}</h1>
                            <small class="text-muted">Project ID: WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT);}} @if(!empty($project->title)), {{ $project->title }} @endif</small>
                        </div>
                        <button style="color:black !important" onclick='$("#viewDocumentsModal").modal("show");' class="btn btn-icon-success btn-sm add-item-btn btn-text-success">
                            <i class="ki-duotone ki-document fs-1"><span class="path1"></span><span class="path2"></span></i>
                            View Documents
                        </button>
                    </div>
                    <div class="card mb-7">
                        <div class="card-body p-5">
                            
                            <div class="mb-3">
                                <small class="text-muted fw-bold">Sub Contract</small>
                                <h2 class="mb-0">{{ $subcontract->title }}</h2>
                                
                            </div>
                            <hr>
                            
                            <p class="mb-0">{{$subcontract->notes}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>

@if($subcontract)
<div class="modal fade" id="viewDocumentsModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-8">Documents</h1>
                     <div class="row justify-content-center">
                         @foreach($subcontract->documents as $document)
                         <div class="col-md-3 text-start mb-3">
                             <a target="_blank" href="{{asset('documents/sub_contracts_quotes/'.$document->file)}}">
                                 <div class="img-box">
                                     @php $doctype = pathinfo($document->file, PATHINFO_EXTENSION); @endphp
                                     <img src="{{asset('img/icons/'.$doctype.'.svg')}}" alt="">
                                 </div>
                                 <p class="fw-bold text-dark">{{ $document->name }}</p>
                             </a>
                         </div>
                     @endforeach
                     </div>
                </div>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@endif
@endsection