@extends('layouts.app')
@section('title', 'Sub Contracts Quote | Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        
        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }
        
        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }
        
        .btn-outline{
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }
        
        .btn-outline-2{
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            color: black !important;
        }
        
        .badge-primary{
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            padding:10px !important;
            font-size: 13px !important;
            font-weight: 500 !important;
        }
        
        .btn-outline i{
            color: #93D500 !important;
            font-size: 18px;
        }
        
        
        
        .btn-outline:hover{
            color: black !important;
        }
        
        .btn-outline:hover i{
            color: black !important;
        }
        
        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 15px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 15px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 70px;
            margin-bottom: 10px;
        }

        .dropzone .dz-message h3 {
            font-size: 15px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 13px;
            color: #6c757d;
        }
        
        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }
        
        .accept-btn{
            color: #008C0E !important;
            border: 1px solid #008C0E33 !important;
            background: #e5f3e7 !important;
            font-size: 15px;
        }
        
        .accept-btn i{
            color: #008C0E !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .send-link-btn{
            color: #5790FF !important;
            border: 1px solid #0048D533 !important;
            background: #eef4ff !important;
            font-size: 15px;
        }
        
        .send-link-btn i{
            color: #5790FF !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .add-item-btn{
            color: #93D500 !important;
            border: 1px solid #93D50033 !important;
            background: #f5ffe0 !important;
            font-size: 15px;
        }
        
        .add-item-btn i{
            color: #93D500 !important;
            font-size: 20px;
            font-weight: bold;
        }
        
        .img-box{
            width: 100%;
            background: #F4F4F4;
            height: 200px;
            border-radius: 8px;
            margin-bottom: 10px;
            position: relative;
        }
        
        .img-box img{
            width: 60px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        
        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            font-weight: 500;
            color: #727879;
        }
        
        
        
        .addContactBtn{
            position: absolute;
            right: -5px;
            top: -5px;
            cursor: pointer;
        }
        
        .addContactBtn .fa-plus-circle{
            font-size: 15px;
        }
        
        .green{
            border-color: #93D500 !important;
        }

    </style>
    
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            
            @if(session('danger'))
            <div class="alert alert-danger">
                {{ session('danger') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            
            
            
            @if($subcontracts->count()>0)
            <div class="card mb-7">
                <div class="p-3">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <ul class="nav nav-pills">
                                @foreach($subcontracts as $sub)
                                <li class="nav-item">
                                    <a class="nav-link {{ $subcontract->id == $sub->id ? 'active' : '' }}" href="{{route('projects.subContractsQuote', ['id' => $project->id])}}?sc_id={{$sub->id}}">{{ $sub->title }}</a>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="col-md-4">
                            
                                <button onclick='$("#kt_modal_new_target").modal("show");' class="btn btn-primary btn-outline w-100"><i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i> New Sub Contractor Quote</button>
                          
                        </div>
                    </div>
                </div>
            </div>
            @else
            <div class="card">
                <div class="p-3">
                    <button onclick='$("#kt_modal_new_target").modal("show");' class="btn btn-primary py-5 btn-lg btn-outline w-100"><i class="ki-outline ki-plus-circle fs-1 me-2"></i> New Sub Contractor Quote</button>
                </div>
            </div>
            @endif
            
            @if($subcontract)
            <div class="card mb-7">
                <div class="card-body">
                    <button style="color:black !important" onclick='$("#addSupplierModal").modal("show");' class="btn btn-icon-success me-3 btn-sm add-item-btn btn-text-success">
                        <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                        Add More Suppliers
                    </button>
                    <div class="float-end">
                        <button style="color:black !important" onclick='$("#viewDocumentsModal").modal("show");' class="btn btn-icon-success me-3 btn-sm add-item-btn btn-text-success">
                            <i class="ki-duotone ki-document fs-1"><span class="path1"></span><span class="path2"></span></i>
                            View Documents
                        </button>
                    </div>
                    <p class="text-muted fw-bold mb-0 mt-5">Notes</p>
                    <p class="fw-bold">{{$subcontract->notes}}</p>
                </div>    
            </div>
            
            @php 
                $accepted = 0;
                foreach($subcontract->suppliers as $sub_supplier){
                    if($sub_supplier->accepted==1){
                        $accepted = 1;
                    }
                }
            @endphp
                
                
                
            
            @php $i = 1; $existing_suppliers = array(); @endphp
            @foreach($subcontract->suppliers as $sub_supplier)
                <div class="card w-100 mb-7">
                    <div class="card-header " id="kt_chat_contacts_header">
                        <!--begin::Card title-->
                        <div class="card-title justify-content-between">
                            
                            <h3 class="fw-bold">Quote {{$i}} <br> 
                            <small class="text-muted">WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}#Q{{$i}}-{{ str_pad($sub_supplier->id, 4, '0', STR_PAD_LEFT) }}</small></h3>
                            
                        </div>
                        <div class="align-self-center">
                            @if($accepted == 0)
                            <button data-id="{{ $sub_supplier->id }}" data-quoteid="WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}#Q{{$i}}-{{ str_pad($sub_supplier->id, 4, '0', STR_PAD_LEFT) }}" data-scid="{{ $subcontract->id }}" class="btn btn-icon-success me-3 btn-sm accept-btn btn-text-success">
                                <i class="ki-duotone ki-check-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                                Accept
                            </button>
                            @elseif($sub_supplier->accepted==1)
                            <button class="btn btn-icon-success me-3 btn-sm add-item-btn btn-text-dark">
                                <i class="ki-duotone ki-check-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                                Accepted
                            </button>
                            
                            @endif
                            
                            
                            <button data-supplier_id="{{ $sub_supplier->supplier_id }}" class="btn btn-icon-success btn-sm me-3 send-link-btn btn-text-success">
                                <i class="ki-duotone ki-send fs-1"><span class="path1"></span><span class="path2"></span></i>
                                Send as link
                            </button>
                            @if($accepted==0)
                            <button data-id="{{ $sub_supplier->id }}" data-name="{{ $sub_supplier->company_name }}" class="btn btn-icon-success addItem btn-sm add-item-btn btn-text-success">
                                <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                                Add Item
                            </button>
                            @endif
                        </div>
                        
                        <!--end::Card title-->
                    </div>
                    <div class="card-body">
                        <span style="font-size:15px !important;color:black;padding:10px !important;border-radius:5px" class="badge badge-primary add-item-btn text-dark mb-3">{{ $sub_supplier->company_name }}</span>
                        
                        <div class="alert alert-secondary">
                            <p class="text-black mb-0">Notes</p>
                            <p class="text-muted mb-0">{{$subcontract->notes}}</p>
                        </div>
                        
                        @if($sub_supplier->accepted==1)
                            <div class="border border-gray-300 border-dashed green  rounded min-w-125px py-3 px-4 me-3 mb-3" id="">
                                <!--begin::Number-->
                                <div class="fw-semibold fs-6 text-success text-gray-500">Accepted for</div>
                                <div class="d-flex align-items-center">

                                    <div class="fs-2 fw-bold counted" data-kt-countup="true" data-kt-countup-value="80" data-kt-initialized="1" id="">£{{number_format($sub_supplier->amount, 2)}}</div>
                                </div>
                                <!--end::Number-->
                                <!--begin::Label-->
                                
                                <!--end::Label-->
                            </div>
                        @endif
                        @if($sub_supplier->items->count()>0)
                        <h4 class="text-black mt-8 mb-3">Accepted Items</h4>
                        <table class="table table-bordered">
                            <tr>
                                <th>Code</th>
                                <th>Description</th>
                            </tr>
                            @foreach($sub_supplier->items as $item)
                                <tr>
                                    <td width="20%">{{ $item->code }}</td>
                                    <td>{{ $item->description }}</td>
                                </tr>
                            @endforeach
                        </table>
                        @endif
                        
                    </div>
                </div>
                @php $i++; $existing_suppliers[] = $sub_supplier->supplier_id; @endphp
            @endforeach
            
            @endif

          
        </div>
    </div>
    <!--end::Content-->
</div>

@if($subcontract)
<div class="modal fade" id="viewDocumentsModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-8">Documents</h1>
                     <div class="row justify-content-center">
                         @foreach($subcontract->documents as $document)
                         <div class="col-md-3 text-start mb-3">
                             <a target="_blank" href="{{asset('documents/sub_contracts_quotes/'.$document->file)}}">
                                 <div class="img-box">
                                     @php $doctype = pathinfo($document->file, PATHINFO_EXTENSION); @endphp
                                     <img src="{{asset('img/icons/'.$doctype.'.svg')}}" alt="">
                                 </div>
                                 <p class="fw-bold text-dark">{{ $document->name }}</p>
                             </a>
                         </div>
                     @endforeach
                     </div>
                </div>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="addSupplierModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('project.addMoreSuppliers', ['id'=>$project->id])}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add More Suppliers</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Title</span>
                        </label>
                        <input type="text" class="form-control" readonly value="{{ $subcontract->title }}">
                    </div>
                    <input type="hidden" name="sub_contract_id" value="{{ $subcontract->id }}">
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Supplier</span>
                        </label>
                        <!--end::Label-->
                        <select required name="supplier_id" class="form-select" id="supplier_select">
                            <option value="">Select</option>
                            @foreach($suppliers as $supplier)
                                @if(!in_array($supplier->id, $existing_suppliers))
                                    <option value="{{ $supplier->id }}">{{ $supplier->company_name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="d-flex flex-column mb-8  fv-row" id="">
                       <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Supplier Contact</span>
                        </label>
                       <select required name="contact_id" class="form-select" id="supplier_contacts">
                            <option value="">Select</option>
                        </select>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@endif

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" id="form-data">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Sub Contracts Quote</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Title</span>
                        </label>
                        <select name="title" class="form-control" id="" required>
                            <option value="">Select</option>
                            @foreach($titles as $title)
                            <option value="{{ $title->name }}">{{ $title->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Notes</span>
                        </label>
                        <textarea name="notes" class="form-control" id="" cols="30" rows="4"></textarea>
                    </div>
                    <input type="hidden" name="project_id" value="{{ $project->id }}">
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Suppliers</span>
                        </label>
                        <!--end::Label-->
                        <select required name="suppliers[]" multiple class="form-select" id="skills_set">
                            <option value="">Select</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}">{{ $supplier->company_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="d-flex flex-column mb-8  fv-row" id="suppliers">
                       
                    </div>
                    
                    <div class="d-flex flex-column mb-8 fv-row" style="display:none" id="zone">
                        <div class="dropzone" id="my-dropzone">
                            <div class="dz-message">
                                <img src="{{asset('img/cloud.svg')}}" alt="Upload">
                                <h3>Upload Documents</h3>
                            </div>
                        </div>
                    </div>






                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="form_submit_btn" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@if($subcontract)
<div class="modal fade" id="addItemModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Add Item</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('projects.addQuoteItem', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">

                        
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" readonly class="form-control" id="supplier_name">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                               
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Category</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="category" id="" required>
                                        <option value="">Select</option>
                                        <option value="plant">Plant</option>
                                        <option value="labour">Labour</option>
                                        <option value="material">Material</option>
                                    </select>
                                    
                                    
                                    
                                    <input type="hidden" name="supplier_id" id="sc_supplier_id">
                                    <input type="hidden" name="sc_id" value="{{ $subcontract->id }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">UoM</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" required name="uom" id="">
                                        <option value="">Select</option>
                                        @foreach($uoms as $uom)
                                        <option value="{{$uom->name}}">{{$uom->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="quantity" step="any" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Amount</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="amount" step="any" required>
                                </div>
                            </div>
                        </div>


                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Enter Description</span>
                            </label>
                            <!--end::Label-->
                            <textarea required name="description" class="form-control" id="" cols="30" rows="5"></textarea>
                        </div>

                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Add Item
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="editItemModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Edit Item</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('projects.updateQuoteItem', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">

                        
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" readonly class="form-control" id="e_supplier_name">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                               
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Category</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="category" id="e_category" required>
                                        <option value="">Select</option>
                                        <option value="plant">Plant</option>
                                        <option value="labour">Labour</option>
                                        <option value="material">Material</option>
                                    </select>
                                    <input type="hidden" name="item_id" id="e_item_id">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">UoM</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" required name="uom" id="e_uom">
                                        <option value="">Select</option>
                                        @foreach($uoms as $uom)
                                        <option value="{{$uom->name}}">{{$uom->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="quantity" step="any" required id="e_quantity">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Amount</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="amount" step="any" required id="e_amount">
                                </div>
                            </div>
                        </div>


                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Enter Description</span>
                            </label>
                            <!--end::Label-->
                            <textarea required name="description" class="form-control" id="e_description" cols="30" rows="5"></textarea>
                        </div>

                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Update Item
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@endif



<div class="modal fade" id="addContactModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="" id="addContactForm">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New Contact</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Name</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Name" name="name" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Email</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Email" name="email" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Phone</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Contact Phone" name="phone" />
                    </div>
                    <input type="hidden" name="supplier_id" id="add_contact_supplier_id">




                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="acceptModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header p-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body  ">
                <!--begin:Form-->


                <div class="mb-8 text-center">
                    <!--begin::Title-->
                    <h1>Accept Quote</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action='{{route("projects.acceptQuote", ["id"=>$project->id])}}' method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">
                        @if($project->tender==0)
                        <table class="table table-bordered mb-8">
                            <thead>
                                <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                    <th></th>
                                    <th>Code</th>
                                    <th>Description</th>
                                    <th>UoM</th>
                                    <th>Price</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-semibold">
                                @foreach($items as $item)
                                    @if($item->sub_contract_accepted==0)
                                <tr>
                                    <td align="center">
                                        <div class="form-check text-center m-0">
                                            <input name="po_items[]" class="form-check-input po-checkbox" type="checkbox" value="{{$item->id}}" id="">
                                        </div>
                                    </td>

                                    <td>{{ $item->code }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>{{ $item->uom }}</td>
                                    <td>£{{ number_format($item->sales_price, 2) }}</td>

                                </tr>
                                    @endif
                                @endforeach
                            </tbody>

                        </table>
                        @else
                        <div class="row mb-6">
                            <div class="col-lg-6 fv-row fv-plugins-icon-container">
                                <label class="col-form-label required fw-semibold fs-6">Type</label><br>
                                <div class="form-check form-check-inline mb-3 form-check-custom form-check-solid me-10">
                                    <input name="type" class="form-check-input " type="radio" checked value="sub_contract" id="flexCheckbox30" />
                                    <label class="form-check-label" for="flexCheckbox30">
                                        Sub Contract
                                    </label>
                                </div>
                                <div class="form-check form-check-inline form-check-custom form-check-solid me-10">
                                    <input name="type" class="form-check-input " type="radio" value="other" id="flexCheckbox302" />
                                    <label class="form-check-label" for="flexCheckbox302">
                                        Other
                                    </label>
                                </div>
                            </div>
                        </div>
                        @endif
                        
                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Final Amount</span>
                            </label>
                            <!--end::Label-->
                            <input required type="number" class="form-control " placeholder="Enter amount" name="final_amount" />
                        </div>

                    </div>
                    @csrf
                    <div class="text-center">
                        <input type="hidden" name="quote_id" id="accept_contract_id">
                        <input type="hidden" name="quote_id_text" id="accept_quote_id">
                        <input type="hidden" name="subcontract_id" id="accept_sc_id">
                        <input type="hidden" name="project_id" value="{{$project->id}}">
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Accept Quote
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@if($subcontract)
<form action="{{ route('project.sendSubContractAsLink', ['id'=>$project->id]) }}" method="post" id="sendAsLinkForm">
    @csrf
    <input type="hidden" name="sub_contract_id" value="{{ $subcontract->id }}">
    <input type="hidden" name="supplier_id" id="send_supplier_id">
</form>
@endif


@endsection


@section('js')
<script>
    
    $(".send-link-btn").click(function(){
        var id = $(this).data('supplier_id');
        $("#send_supplier_id").val(id);
        $("#sendAsLinkForm").submit();
    });
    
    $(document).on('click', '.addContactBtn', function(){
        $("#add_contact_supplier_id").val($(this).data('supplier_id'));
        $("#kt_modal_new_target").modal("hide");
        $("#addContactModal").modal("show");
        
    });
    
    
    $("#addContactForm").submit(function(e){
        e.preventDefault();
        $.ajax({
            url: '{{route("project.addSupplierContact")}}',
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            data: $("#addContactForm").serialize(),
            success: function(response) {
                var contact = JSON.parse(response);
                if(contact.exists==0){
                    $("#addContactModal").modal("hide");
                    $("#kt_modal_new_target").modal("show");
                    $("#supplier_contacts_"+contact.supplier_id).append('<option value="'+contact.contact_id+'">'+contact.name+' ('+contact.email+')'+'</option>');
                    $("#supplier_contacts_"+contact.supplier_id).val(contact.contact_id);
                }else{
                    alert('Contact with this email already exists.');
                }
            }
        });
    });
    
    $(".accept-btn").click(function(){
        
        
        var id = $(this).data('id');
        var quoteid = $(this).data('quoteid');
        var scid = $(this).data('scid');
        $("#accept_contract_id").val(id);
        $("#accept_quote_id").val(quoteid);
        $("#accept_sc_id").val(scid);
        $("#acceptModal").modal("show");
        
        /*if(confirm('Are you sure want to accept this quote?')){
            
            $("#acceptForm").submit();
        }*/
    });
    
    $(".editBtn").click(function(){
        var id = $(this).data('id');
        var supplier = $(this).data('supplier');
        $.ajax({
            url: '{{route("projects.getQuoteItemDetails", ["id"=>$project->id])}}',
            method: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            data: { item_id: id },
            success: function(response) {
                $("#e_item_id").val(id);
                $("#e_supplier_name").val(supplier);
                $("#e_uom").val(response.item.uom);
                $("#e_category").val(response.item.category);
                $("#e_amount").val(response.item.amount);
                $("#e_quantity").val(response.item.quantity);
                $("#e_description").val(response.item.description);
                $("#editItemModal").modal("show");
            }
        });
    });
    
    
    $(".addItem").click(function(){
        var id = $(this).data('id');
        $("#supplier_name").val($(this).data('name'));
        $("#sc_supplier_id").val($(this).data('id'));
        $("#addItemModal").modal("show");
    });
    
    $('#addContactModal').on('hidden.bs.modal', function () {
        setTimeout(function() {
            $('body').addClass('modal-open');
        }, 500);
    });
    
    $('#skills_set').select2();
    var supplier_append = 0;
    $('#skills_set').on('select2:select', function(e) {
        var selectedValue = e.params.data.id;
        var selectedText = e.params.data.text;
        if(supplier_append==0){
            $("#suppliers").append('<label class="d-flex align-items-center fs-6 fw-semibold mb-2"><span class="required">Select Contacts</span></label>');
            supplier_append = 1;
        }
        $.ajax({
            url: '{{route("projects.getSupplierContacts")}}', // Replace with your server endpoint
            method: 'GET',
            data: { supplier_id: selectedValue },
            success: function(response) {
                var data = JSON.parse(response);
                var options = "";
                for(var i=0; i<data.length;i++){
                    options+= '<option value="'+data[i].id+'">'+data[i].name+' ('+data[i].email+')</option>';
                }
                $("#suppliers").append('<div class="row mb-3" id="supplier_'+selectedValue+'"><div class="col-md-6"><input readonly class="form-control" type="text" value="'+selectedText+'"></div><div class="col-md-6"><div style="position:relative"><span data-supplier_id="'+selectedValue+'" class="addContactBtn"><i class="fa fa-plus-circle fa-2x openModal"></i></span><select id="supplier_contacts_'+selectedValue+'" required name="contact['+selectedValue+']" class="form-select"><option value="">Select Contact</option>'+options+'</select></div></div></div>');
            }
        });
    });
    
    $('#skills_set').on('select2:unselect', function(e) {
        var unselectedValue = e.params.data.id;

        // Remove input element
        $('#supplier_' + unselectedValue).remove();
    });
    
    
    $("#supplier_select").change(function(){
        var supplier_id = $(this).val();
        $.ajax({
            url: '{{route("projects.getSupplierContacts")}}', // Replace with your server endpoint
            method: 'GET',
            data: { supplier_id: supplier_id },
            success: function(response) {
                var data = JSON.parse(response);
                var options = "";
                for(var i=0; i<data.length;i++){
                    options+= '<option value="'+data[i].id+'">'+data[i].name+' ('+data[i].email+')</option>';
                }
                $("#supplier_contacts").html(options);
            }
        });
    });
    
    
    Dropzone.autoDiscover = false;

    // Initialize Dropzone
    var myDropzone = new Dropzone("#my-dropzone", {
        url: "{{route('project.uploadSubContractDocuments', ['id'=>$project->id])}}", // Set the url for your upload script
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
        },
        autoProcessQueue: false, // Prevent Dropzone from uploading automatically
        addRemoveLinks: true,
        parallelUploads: 100 // Allow multiple uploads at the same time
    });

    // Handle the form submission
    document.querySelector("#form-data").addEventListener("submit", function(e) {
        e.preventDefault();
        $("#form_submit_btn").prop('disabled', true);

        // Submit the form via AJAX
        $.ajax({
            url: "{{route('project.addSubContractQuotes', ['id'=>$project->id])}}",
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                // Assuming the response contains the ID
                var returnedId = response;

                // Append extra data to the form
                myDropzone.on("sending", function(file, xhr, formData) {
                    formData.append("sub_contract_id", returnedId); // Append the returned ID
                });

                // Process the Dropzone queue
                if (myDropzone.getQueuedFiles().length > 0) {
                    myDropzone.processQueue(); // Process the queue if files exist
                } else {
                    alert("Sub Contracts Quote added successfully.");
                    window.location.reload();
                }
            },
            error: function(xhr, status, error) {
                console.error('Form submission failed:', error);
                $("#form_submit_btn").prop('disabled', false);
                alert('Form submission failed. Please try again.');
                
            }
        });
    });

    // Event listener for when all files have been processed
    myDropzone.on("queuecomplete", function() {
        // You can do additional tasks here, like showing a success message or redirecting
        alert("Sub Contracts Quote added successfully.");
        window.location.reload();
    });

    // Event listener for handling errors
    myDropzone.on("error", function(file, errorMessage) {
        alert("Error uploading file: " + errorMessage);
    });
    
    
</script>
@endsection
