@extends('layouts.app')
@section('title', 'Variation Quotation')

@section('css')
<style>
    #kt_app_sidebar {
        display: none;
    }

    #kt_app_header {
        display: none;
    }

    #kt_app_wrapper {
        margin: 0;
    }
    
    @media print {
        .no-print-style {
            background-color: white !important;
            border: none !important;
            box-shadow: none !important;
            padding: 0 !important;
            margin: 0 !important;
        }
        
        body, 
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
        
        .no-print-style-body{
            background: white;
        }
        
        #kt_app_body{
            background: white;
        }
        
        .btn-primary{
            display: none !important;
        }
    }

</style>
@endsection

@section('content')

<style>
    .table td,
    .table th {
        vertical-align: middle;
    }

    .table td {
        background: #93D5001A;
        border: 3px solid white !important;
        padding: 8px !important;
        color: black !important;
        text-align: center;
        color: #727879;
    }

    .table th {
        border: 3px solid white !important;
        background: #E3E3E3;
        color: #5E5E5E !important;
        font-weight: 500;
        font-size: 12px;
        margin: 10px !important;
        text-align: center;
    }



    .price-column {
        background: #E3E3E3 !important;
    }


    table.table-bordered.dataTable {
        border: 0;
        border-bottom: 0;
    }

    .price-table td {
        font-size: 16px;
        padding-bottom: 15px;
        text-align: right;
    }

    .price-table th {
        font-size: 16px;
        font-weight: bold;
        padding-right: 25px;
        padding-bottom: 15px;
    }
    
    

</style>

<div class="d-flex flex-column flex-column-fluid">

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            
            <div class="row justify-content-center">
                <div class="col-md-8">
                    @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                    @endif
                    <div class="card no-print-style">
                        <!-- begin::Body-->
                        <div class="card-body py-20">
                            @if($variation->status=='accepted')
                            <span class="badge badge-light-primary" style="font-size:16px;position:absolute;top:10px;left:10px">
                                <i class="ki-outline ki-check-circle fs-5 text-primary me-2 fw-bolder"></i> Accepted</span>
                            @elseif($variation->status=='declined')
                            <span class="badge badge-light-danger" style="font-size:16px;position:absolute;top:10px;left:10px">
                                <i class="ki-outline ki-cross-circle fs-5 text-danger me-2 fw-bolder"></i> Declined</span>
                            @endif
                            <!-- begin::Wrapper-->
                            <div class="mw-lg-950px mx-auto w-100">
                                <!-- begin::Header-->
                                <div class="mb-19" style="position:relative">
                                    <div style="position:absolute;right:20px;top:-25px"><img width="150px" src="{{asset('img/walker.png')}}"></div>
                                    <h4 style="font-size:22px; !important" class="fw-bolder text-gray-800  pe-5 pb-7 text-center">Variation Quotation</h4>
                                    <!--end::Logo-->

                                </div>
                                <!--end::Header-->
                                <!--begin::Body-->
                                <div class="pb-12">
                                    <!--begin::Wrapper-->
                                    <div class="d-flex flex-column gap-7 gap-md-10">
                                        <!--begin::Message-->
                                        

                                        <div class="text-dark">
                                            <div style="font-weight:500" class="mb-5">
                                                {{$customer->company_name}} <br>
                                                {{$customer->address_1}} <br>
                                                {{$customer->town}} <br>
                                                {{$customer->county}} <br>
                                                {{$customer->postcode}} <br>
                                            </div>
                                            <div class="mb-8">
                                                @if($variation->sent==1)
                                                <p class="mb-0"><b>Attention:</b> {{ ucwords($contact->name) }}</p>
                                                @endif
                                                <p class="mb-0"><b>Our Ref: </b> WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}#V-{{ str_pad($variation->id, 4, '0', STR_PAD_LEFT) }}</p>
                                                <p class="mb-0"><b>Your Ref:</b> {{ $project->customer_ref }} - {{ $project->end_customer_name }}</p>
                                            </div>
                                            <div class="">
                                                <p>Please find below variation request. </p>
                                                <p>If you can accept or decline the variation as soon as possible, as we have workers on site ready to commence the work</p>
                                                <p><b>Notes Section:</b><br>
                                                    {{$variation->description}}
                                                </p>
                                            </div>
                                            

                                            

                                        </div>
                                        <!--begin::Message-->
                                        <!--begin::Separator-->
                                        
                                        <p class="mb-0"><b>Extra Work Required:</b></p>
                                        <table class="table table-bordered">
                                            <tr>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Qty</th>
                                                <th>Sales Rate</th>
                                                <th>Sales Gross</th>
                                            </tr>
                                            @foreach($items as $item)
                                            <tr>
                                                <td width="20%">{{ $item->code }}</td>
                                                <td width="40%">{{ $item->description }}</td>
                                                <td width="10%">{{ $item->quantity }}</td>
                                                <td width="15%">£{{ number_format($item->sales_price, 2) }}</td>
                                                <td width="15%">£{{ number_format($item->sales_price*$item->quantity, 2) }}</td>
                                            </tr>
                                            @endforeach

                                        </table>
                                        
                                        
                                        
                                        


                                    </div>
                                    <!--end::Wrapper-->
                                </div>
                                <div class="float-end">
                                    <p>Your sincerely <br>
                                        {{ $contracts_manager->firstname }} {{ $contracts_manager->lastname }}</p>
                                </div>
                                <!--end::Body-->
                                <!-- begin::Footer-->
                                
                                <div class="justify-content-center flex-wrap text-center mt-lg-20 pt-13">
								   <hr>
                                   <p>Walker Group, Ashlar House, 230 Cumberworth Lane, Denby Dale, Huddersfield HD8 8PR</p>			
                                    <!-- end::Action-->
                                </div>
                                <!-- end::Footer-->
                            </div>
                            <!-- end::Wrapper-->
                        </div>
                        <!-- end::Body-->
                    </div>
                    @if(request()->has('print'))
                    <div class="text-center mt-5 mb-5">
                        <button id="'printButton" class="btn btn-primary" onclick="window.print()">Print</button>
                    </div>
                    @else    
                        @if($variation->status=='pending')
                        <div class="text-center mt-5 mb-5" >
                           <button class="btn btn-primary changeStatus me-3" data-status="accepted" data-status2="accept">Accept</button>
                           <button  class="btn btn-danger changeStatus" data-status="declined" data-status2="decline">Decline</button>
                        </div>
                        @endif
                    @endif
                </div>
            </div>
            @if($variation->status=='pending')
            <form action="{{ route('project.changeVariationStatus') }}" method="post" id="changeStatusForm">
                <input type="hidden" name="status" id="status">
                @csrf
                <input type="hidden" name="variation_id" value="{{ $variation->id }}">
            </form>
            @endif

        </div>
    </div>
    <!--end::Content-->
</div>


@endsection


@section('js')
<script>
    
    $(".changeStatus").click(function(){
        var status = $(this).data('status');
        var status2 = $(this).data('status2');
        if(confirm('Are you sure want to '+status2+' this variation?')){
            $("#status").val(status);
            $("#changeStatusForm").submit();
        }
    });
    
    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

    $(".edit").click(function() {
        var id = $(this).data('id');
        var name = $(this).data('name');
        $("#e_name").val(name);
        $("#e_id").val(id);
        $("#editModal").modal("show");
    })

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    })

</script>
@endsection
