@extends('layouts.app')
@section('title', 'Variations | Project Details')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <style>
        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }
        
        .send-link-btn{
            color: #5790FF !important;
            border: 1px solid #0048D533 !important;
            background: #eef4ff !important;
            font-size: 15px;
        }
        
        .send-link-btn i{
            color: #5790FF !important;
            font-size: 20px;
            font-weight: bold;
        }

        .project-image {
            width: 100%;
            height: 428px;
            object-fit: cover;
        }

        iframe {
            width: 100% !important;
            height: 300px !important;
            margin: 0 !important;
            border-radius: 10px;
        }

        .nav-link {
            font-size: 18px;
            color: #5E5E5E;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            border: 1px solid #93D50066;
            background: white;
            color: black;
            font-weight: 500;
        }

        .page-heading {
            font-size: 24px !important;
        }

        .project-id {
            font-size: 18px;
            color: #556171 !important;
        }

        .form-check-input:checked {
            border-color: #93d500;
        }

        .btn-outline {
            border: 1px dashed #93D500 !important;
            background: #F5FFE0 !important;
            color: #93D500 !important;
        }

        .btn-outline-2 {
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            color: black !important;
        }

        .badge-primary {
            border: 1px solid #93D500 !important;
            background: #F5FFE0 !important;
            padding: 10px !important;
            font-size: 13px !important;
            font-weight: 500 !important;
        }

        .btn-outline i {
            color: #93D500 !important;
            font-size: 18px;
        }

        .btn-outline:hover {
            color: black !important;
        }

        .btn-outline:hover i {
            color: black !important;
        }

        .dropzone {
            border: 2px dashed #007bff;
            border-radius: 5px;
            background: #f8f9fa;
            padding: 15px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            cursor: pointer;
        }

        .dropzone .dz-message {
            font-size: 15px;
            font-weight: bold;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .dropzone .dz-message img {
            max-width: 70px;
            margin-bottom: 10px;
        }

        .dropzone .dz-message h3 {
            font-size: 15px;
            margin: 10px 0;
        }

        .dropzone .dz-message p {
            font-size: 13px;
            color: #6c757d;
        }

        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        .accept-btn {
            color: #008C0E !important;
            border: 1px solid #008C0E33 !important;
            background: #e5f3e7 !important;
            font-size: 15px;
        }

        .accept-btn i {
            color: #008C0E !important;
            font-size: 20px;
            font-weight: bold;
        }

        .send-link-btn {
            color: #5790FF !important;
            border: 1px solid #0048D533 !important;
            background: #eef4ff !important;
            font-size: 15px;
        }

        .send-link-btn i {
            color: #5790FF !important;
            font-size: 20px;
            font-weight: bold;
        }

        .add-item-btn {
            color: #93D500 !important;
            border: 1px solid #93D50033 !important;
            background: #f5ffe0 !important;
            font-size: 15px;
        }

        .add-item-btn i {
            color: #93D500 !important;
            font-size: 20px;
            font-weight: bold;
        }

        .img-box {
            width: 100%;
            background: #F4F4F4;
            height: 200px;
            border-radius: 8px;
            margin-bottom: 10px;
            position: relative;
        }

        .img-box img {
            width: 60px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
            font-weight:500;
        }

    </style>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row align-items-center mb-7">
                <div class="col-md-12">
                    @include('project.nav')
                </div>

            </div>


            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif


            <div class="card mb-7">
                <div class="card-header">
                    <div class="card-title justify-content-between">
                        <h3 class="fw-bold">Variations</h3>
                    </div>
                    <div class="align-self-center">

                        <button onclick='$("#addVariationModal").modal("show");' class="btn btn-icon-success me-3 btn-sm add-item-btn btn-text-success">
                            <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                            Add Variations
                        </button>
                    </div>
                </div>
            </div>

           @foreach($variations as $variation)
            <div class="card w-100 mb-7">
                <div class="card-header " id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title justify-content-between">
                        <h3 class="fw-bold me-3">{{ $variation->name }}</h3>
                            @if($variation->sent==1 && $variation->status=='pending')
                                <span class="badge badge-light-warning" style="font-size:14px;">
                                    <i class="ki-outline ki-exclamation-circle fs-5 text-primary me-2 fw-bolder"></i> Pending with client - Variation locked</span>
                            @else
                                @if($variation->status=='accepted')
                                <span class="badge badge-light-primary" style="font-size:14px;">
                                    <i class="ki-outline ki-check-circle fs-5 text-primary me-2 fw-bolder"></i> Accepted</span>
                                @elseif($variation->status=='declined')
                                <span class="badge badge-light-danger" style="font-size:14px;">
                                    <i class="ki-outline ki-cross-circle fs-5 text-danger me-2 fw-bolder"></i> Declined</span>
                                @endif
                            @endif
                    </div>
                    <div class="align-self-center">
                        
                        @if($variation->status=='pending' && $variation->sent==0)
                        <button data-items="{{ $variation->items->count() }}" data-id="{{ $variation->id }}" class="btn btn-icon-success btn-sm me-2 send-link-btn sendVariation btn-text-success">
                            <i class="ki-duotone ki-send fs-1"><span class="path1"></span><span class="path2"></span></i>
                            Send as link
                        </button>
                        <button data-id="{{ $variation->id }}" data-name="{{ $variation->name }}" class="btn btn-icon-success me-3 btn-sm add-item-btn addItem btn-text-success">
                            <i class="ki-duotone ki-plus-circle fs-1"><span class="path1"></span><span class="path2"></span></i>
                            Add Item
                        </button>
                        @else
                        <a target="_blank" href="{{ route('project.viewVariation', ['projectid'=>$project->id, 'id'=>$variation->id]) }}?print" class="btn btn-icon-success btn-sm me-2 send-link-btn btn-text-success">
                            <i class="ki-duotone ki-printer fs-1"><span class="path1"></span><span class="path2"></span></i>
                            Print
                        </a>
                        
                        <button data-link="{{ route('project.viewVariationByLink', ['token'=>$variation->token]) }}" class="btn btn-icon-success btn-sm me-2 send-link-btn copyLink btn-text-success">
                            <i class="ki-duotone ki-copy fs-1"><span class="path1"></span><span class="path2"></span></i>
                            Copy Link
                        </button>
                        
                        @endif
                    </div>

                    <!--end::Card title-->
                </div>
                <div class="card-body">


                    <p class=" fw-bold mb-0 ">Notes:</p>
                    <p class="" style="color:#5E5E5E">{{$variation->description}}</p>
                    <table class="table table-bordered">
                        <tr>
                            <th>Code</th>
                            <th>Description</th>
                            <th>UoM</th>
                            <th>Qty</th>
                            <th>Sales Rate</th>
                            <th>Sales Gross</th>
                        </tr>
                        @foreach($variation->items as $item)
                            <tr>
                                <td width="20%">{{ $item->code }}</td>
                                <td width="40%">{{ $item->description }}</td>
                                <td width="10%">{{ $item->uom }}</td>
                                <td width="10%">{{ $item->quantity }}</td>
                                <td width="10%">£{{ number_format($item->sales_price, 2) }}</td>
                                <td width="10%">£{{ number_format($item->sales_price*$item->quantity, 2) }}</td>
                            </tr>
                        @endforeach

                    </table>

                </div>
            </div>
            @endforeach



        </div>
    </div>
    <!--end::Content-->
</div>



<div class="modal fade" id="sendVarationModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog   ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Send Variation</h1>
                    <p id="supplier_name"></p>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('projects.sendVariation', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">



                        <div class="row">
                            
                            <div class="col-md-12">
                                <div class="mb-8">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Select Contact</span>
                                    </label>
                                    <!--end::Label-->
                                    <select required name="contact_id" class="form-select" id="" >
                                        <option value="">Select</option>
                                        @foreach($contacts as $contact)
                                        <option value="{{$contact->id}}">{{ucwords($contact->name)}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <input type="hidden" name="variation_id" id="send_variation_id">
                        </div>
                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Send
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>



<div class="modal fade" id="addItemModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Add Item</h1>
                    <p id="supplier_name"></p>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('projects.addVariationItem', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">



                        <div class="row">
                            
                            <div class="col-md-12">
                                <div class="mb-8">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Code</span>
                                    </label>
                                    <!--end::Label-->
                                    <select required name="code" class="form-select" id="add_financials" data-placeholder="Select">
                                        <option></option>
                                        @foreach($f_items as $f_item)
                                        <option data-amount="{{ $f_item->sales_price }}" value="{{$f_item->id}}">{{$f_item->code}} - {{$f_item->description}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <input type="hidden" name="variation_id" id="variation_id">
                            
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" id="quantity" name="quantity" step="any" required value="1">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Sales Price</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" readonly value="0" id="sales_price">
                                </div>
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Add Item
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="editItemModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-lg  ">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->


                <div class="mb-13 text-center">
                    <!--begin::Title-->
                    <h1 class="mb-3">Edit Item</h1>
                    <!--end::Title-->
                    <!--begin::Description-->

                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Input group-->

                <form action="{{route('projects.updateQuoteItem', ['id'=>$project->id])}}" method="post" enctype="multipart/form-data">
                    <div class="d-flex flex-column mb-8 fv-row">



                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="">Supplier</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="text" readonly class="form-control" id="e_supplier_name">
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Category</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" name="category" id="e_category" required>
                                        <option value="">Select</option>
                                        <option value="plant">Plant</option>
                                        <option value="labour">Labour</option>
                                        <option value="material">Material</option>
                                    </select>
                                    <input type="hidden" name="item_id" id="e_item_id">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">UoM</span>
                                    </label>
                                    <!--end::Label-->
                                    <select class="form-control" required name="uom" id="e_uom">
                                        <option value="">Select</option>
                                        @foreach($uoms as $uom)
                                        <option value="{{$uom->name}}">{{$uom->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Quantity</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="quantity" step="any" required id="e_quantity">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <!--begin::Label-->
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Amount</span>
                                    </label>
                                    <!--end::Label-->
                                    <input type="number" class="form-control" name="amount" step="any" required id="e_amount">
                                </div>
                            </div>
                        </div>


                        <div class="d-flex flex-column mb-8 fv-row">
                            <!--begin::Label-->
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Enter Description</span>
                            </label>
                            <!--end::Label-->
                            <textarea required name="description" class="form-control" id="e_description" cols="30" rows="5"></textarea>
                        </div>

                    </div>
                    @csrf
                    <div class="text-center">

                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Update Item
                        </button>
                    </div>
                </form>
                <!--end::Actions-->

                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


<div class="modal fade" id="addVariationModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" action="{{ route('projects.addVariation', ['id'=>$project->id]) }}" class="form" id="form-data">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add Variation</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Variation Name</span>
                        </label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Notes</span>
                        </label>
                        <textarea name="notes" class="form-control" id="" cols="30" rows="4"></textarea>
                    </div>




                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
<input type="hidden" id="variation_link" value="">

@endsection


@section('js')
<script>
    
    /*$(".copyLink").click(function(){
        var elem = $(this);
        var link = $(this).data('link');
        myFunction(link);
        elem.html('<i class="ki-duotone ki-check fs-1"><span class="path1"></span><span class="path2"></span></i> Copied');
        setTimeout(function(){
            elem.html('<i class="ki-duotone ki-copy fs-1"><span class="path1"></span><span class="path2"></span></i> Copy Link');
        }, 2000);
        
    });*/
    
$(document).ready(function() {
    $(".copyLink").click(function() {
        var elem = $(this);
        // Get the value of the data-link attribute from the clicked button
        var link = $(this).data("link");

        // Create a temporary input element to hold the text
        var tempInput = $("<input>");
        $("body").append(tempInput);
        tempInput.val(link).select();

        // Copy the text to the clipboard
        document.execCommand("copy");

        // Remove the temporary input element
        tempInput.remove();

        // Display a message or provide feedback to the user
        elem.html('<i class="ki-duotone ki-check fs-1"><span class="path1"></span><span class="path2"></span></i> Copied');
        setTimeout(function(){
            elem.html('<i class="ki-duotone ki-copy fs-1"><span class="path1"></span><span class="path2"></span></i> Copy Link');
        }, 2000);
    });
});
    
    $(".sendVariation").click(function(){
        var id = $(this).data('id');
        var items = $(this).data('items');
        if(items==0){
            alert('Erorr, Please add atleast one item to this variation.'); 
            return false;
        }
        $("#send_variation_id").val(id);
        $("#sendVarationModal").modal("show");
    });
    
    $("#add_financials").change(function(){
         var selectedOption = $(this).find('option:selected');
         var dataInfo = selectedOption.data('amount');
         $("#sales_price").val(dataInfo.toFixed(2));
    });

    
    $(".addItem").click(function(){
        var id = $(this).data('id');
        $("#variation_name").val($(this).data('name'));
        $("#variation_id").val($(this).data('id'));
        $("#addItemModal").modal("show");
    });
    
    $(".accept-btn").click(function() {
        if (confirm('Are you sure want to accept this quote?')) {
            var id = $(this).data('id');
            var quoteid = $(this).data('quoteid');
            var scid = $(this).data('scid');
            $("#accept_contract_id").val(id);
            $("#accept_quote_id").val(quoteid);
            $("#accept_sc_id").val(scid);
            $("#acceptForm").submit();
        }
    });

    $(".editBtn").click(function() {
        var id = $(this).data('id');
        var supplier = $(this).data('supplier');
        $.ajax({
            url: '{{route("projects.getQuoteItemDetails", ["id"=>$project->id])}}',
            method: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            data: {
                item_id: id
            },
            success: function(response) {
                $("#e_item_id").val(id);
                $("#e_supplier_name").val(supplier);
                $("#e_uom").val(response.item.uom);
                $("#e_category").val(response.item.category);
                $("#e_amount").val(response.item.amount);
                $("#e_quantity").val(response.item.quantity);
                $("#e_description").val(response.item.description);
                $("#editItemModal").modal("show");
            }
        });
    });
    
    $('#add_financials').select2({
        dropdownParent: $('#addItemModal')
    });
    
    
    


    $(".addItem").click(function() {
        var id = $(this).data('id');
        $("#supplier_name").html($(this).data('name'));
        $("#sc_supplier_id").val($(this).data('id'));
        $("#addItemModal").modal("show");
    });
</script>
@endsection
