@extends('layouts.app')
@section('title', 'Bid to Win Report')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-4">
                    <div class="card w-100">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Quotes Converted</span></p>
                            <h1 style="font-size:22px;" id="total_projects">{{ $total_quotes }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Win %</span></p>
                            <h1 style="font-size:22px;" id="win_percent">{{ number_format($win_percentage, 2) }}</h1>
                        </div>
                    </div>
                </div>
            </div>
            <form action="{{ route('reports.showCostVariance') }}" method="get">
                <div class="row mb-5 align-items-center">
                    
                    <div class="col-md-3">
                        <input required @if(!request()->has('from')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="From" name="from" value="@if(request()->has('from')){{request()->from}}@endif" />
                    </div>
                    <div class="col-md-3">
                        <input required @if(!request()->has('to')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="To" name="to" value="@if(request()->has('to')){{request()->to}}@endif" />
                    </div>
                    <div class="col-md-2">
                        <button class="btn w-100 btn-primary ">Filter</button>
                    </div>
                </div>
            </form>
            @if(!request()->has('from'))
            <p class=""><i>Showing results from past 90 days.</i></p>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body p-0">
                            <!--begin::Table-->
                            <table class="table table-bordered mb-0" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                        <th align="left">Project</th>
                                        <th align="left">Added On</th>
                                    </tr>
                                </thead>
                                <tbody class="">
                                   
                                   @foreach($projects as $project) 
                                    <tr>
                                        <td width="50%">WG-{{ str_pad($project->id, 4, '0', STR_PAD_LEFT) }} &#8226; <a target="_blank" class="text-dark" href="{{route('projects.financials', ['id'=>$project->id])}}">{{ !empty($project->title) ? $project->title : 'Untitled' }} </a></td>
                                        <td>{{ date('jS M Y', strtotime($project->created_at)) }}</td>
                                        
                                    </tr>

                                    @endforeach
                                </tbody>
                            </table>
                          
                            
                            
                            
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>
@endsection
@section('js')
<script>
</script>
@endsection