@extends('layouts.app')
@section('title', 'Cost Variance Report')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-4">
                    <div class="card w-100">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Projects</span></p>
                            <h1 style="font-size:22px;" id="total_loss_projects">0</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Loss</span></p>
                            <h1 style="font-size:22px;" id="total_loss">0</h1>
                        </div>
                    </div>
                </div>
            </div>
            <form action="{{ route('reports.showCostVariance') }}" method="get">
                <div class="row mb-5 align-items-center">
                    
                    <div class="col-md-3">
                        <input required @if(!request()->has('from')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="From" name="from" value="@if(request()->has('from')){{request()->from}}@endif" />
                    </div>
                    <div class="col-md-3">
                        <input required @if(!request()->has('to')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="To" name="to" value="@if(request()->has('to')){{request()->to}}@endif" />
                    </div>
                    <div class="col-md-2">
                        <button class="btn w-100 btn-primary ">Filter</button>
                    </div>
                </div>
            </form>
            @if(!request()->has('from'))
            <p class=""><i>Showing results from past 90 days.</i></p>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body p-0">
                            <!--begin::Table-->
                            <table class="table table-bordered mb-0" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                        <th align="left">Project</th>
                                        <th>Total Sales</th>
                                        <th>Total Estimated</th>
                                        <th>Total Purchases</th>
                                        <th>Difference</th>
                                    </tr>
                                </thead>
                                <tbody class="">
                                   
                                    @php 
                                        $total_loss_projects = 0;
                                        $total_loss = 0;
                                        $grand_sales = 0;
                                        $grand_estimated_profit = 0;
                                        $grand_actual_profit = 0;
                                        $months = ['09-2024', '10-2024', '11-2024'];
                                        $result = array_fill_keys($months, [
                                            'project_ids' => [],
                                            'sales_net' => 0,
                                            'estimated_profit' => 0,
                                            'actual_profit' => 0,
                                        ]);
                                    @endphp
                                   
                                    @foreach($projects as $project)
                                        @php
                                            $plant = 0;
                                            $labour = 0;
                                            $material = 0;
                                            $subcontract = 0;
                                            $other = 0;
                                            $sales_net = 0;
                                            $sub_contracts_total = 0;
                                            $sub_contracts_other_total = 0;
                                            $estimated_net = 0;
                                            $po_total_plant = 0;
                                            $po_total_material = 0;
                                            $po_total_labour = 0;
                                            $po_total = 0;
                                            $estimated_gross_profit = 0;
                                            $actual_gross_profit = 0;
                                            
                                            
                                            
                                            
                                        @endphp
                                        @if($project->tender==1)
                                            <?php
                                                 foreach($project->tenderItems as $ti){
                                                    $plant += $ti->plant;
                                                    $labour += $ti->labour;
                                                    $material += $ti->material;
                                                    $subcontract += $ti->sub_contract;
                                                    $other += $ti->other;
                                                 }
                                                 
                                                $sales_net = $plant+$labour+$material+$subcontract+$other;
                                                
                                                $plant_estimated = $plant*0.60;
                                                $labour_estimated = $labour*0.60;
                                                $material_estimated = $material*0.60;
                                                $subcontract_estimated = ($subcontract*0.60-$sub_contracts_total);
                                                $other_estimated = ($other*0.60-$sub_contracts_other_total);
                                    
                                                $estimated_net = $plant_estimated+$labour_estimated+$material_estimated+$subcontract_estimated+$other_estimated;
                                                
                                                foreach($project->sub_contracts as $sc){
                                                    if($sc->type=='sub_contract'){
                                                        $sub_contracts_total+=$sc->amount;
                                                    }

                                                    if($sc->type=='other'){
                                                        $sub_contracts_other_total+=$sc->amount;
                                                    }
                                                }
                                    
                                            
                                                foreach($project->purchase_orders as $po){
                                                    $po_total += $po->total;
                                                }
                                    
                                                $estimated_gross_profit = $sales_net-$estimated_net;
                                                $actual_gross_profit = $sales_net - ($estimated_net + $po_total);
                                    
                                                $grand_sales += $sales_net;
                                                $grand_estimated_profit += $estimated_gross_profit;
                                                $grand_actual_profit += $actual_gross_profit;
                                    
                                    
                                            ?>
                                        @else
                                        
                                            <?php
                                                foreach($project->items as $item){
                                                    $plant += $item->plant*$item->quantity;
                                                    $labour += $item->labour*$item->quantity;
                                                    $material += $item->material*$item->quantity;
                                                 }
                                    
                                                foreach($project->purchase_orders as $po){
                                                    $po_total += $po->total;
                                                }
                                    
                                                 $sales_net = $plant+$labour+$material;
                                                 $plant_estimated = $plant*0.60;
                                                 $labour_estimated = $labour*0.60;
                                                 $material_estimated = $material*0.60;
                                    
                                                 $estimated_net = $plant_estimated+$labour_estimated+$material_estimated;
                                                $estimated_gross_profit = $sales_net-$estimated_net;
                                                $actual_gross_profit = $sales_net - ($estimated_net + $po_total);
                                    
                                    
                                                $grand_sales += $sales_net;
                                                $grand_estimated_profit += $estimated_gross_profit;
                                                $grand_actual_profit += $actual_gross_profit;
                                        ?>
                                        @endif
                                        
                                        <?php
                                            $createdDate = \Carbon\Carbon::parse($project->created_at);
                                            $monthYear = $createdDate->format('m-Y'); // Format to match your months array

                                            // Check if the monthYear exists in the months array
                                            if (array_key_exists($monthYear, $result)) {
                                                // Add the project ID to the corresponding month in the result
                                                $result[$monthYear]['project_ids'][] = $project->id;
                                                // Sum the sales_net, estimated_profit, and actual_profit
                                                $result[$monthYear]['sales_net'] += $sales_net;
                                                $result[$monthYear]['estimated_profit'] += $estimated_gross_profit;
                                                $result[$monthYear]['actual_profit'] += $actual_gross_profit;
                                            }
                                    
                                        ?>
                                        
                                    @if($po_total>$estimated_net)
                                    <tr>
                                        <td width="30%">WG-{{ str_pad($project->id, 4, '0', STR_PAD_LEFT) }} &#8226; <a target="_blank" class="text-dark" href="{{route('projects.financials', ['id'=>$project->id])}}">{{ !empty($project->title) ? $project->title : 'Untitled' }} </a></td>
                                        <td width="15%">£{{ number_format($sales_net, 2) }}</td>
                                        <td width="15%">£{{ number_format($estimated_net, 2) }}</td>
                                        <td width="15%">£{{ number_format($po_total, 2) }}</td>
                                        <td width="15%" ><span class="text-danger">£{{ number_format($po_total-$estimated_net, 2) }}</span></td>
                                    </tr>
                                    @php $total_loss_projects++; $total_loss+=$po_total-$estimated_net; @endphp
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                            <?php
                                $result = array_filter($result, function ($monthData) {
                                    return !empty($monthData['project_ids']);
                                });
                                //echo "<pre>";
                                //print_r($result);
                            ?>
                            
                            
                            
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>
@endsection
@section('js')
<script>
    $("#total_loss").html('£{{ number_format($total_loss, 2) }}');
    $("#total_loss_projects").html('{{ $total_loss_projects }}');
</script>
@endsection