@extends('layouts.app')
@section('title', 'Project Job Duration')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Projects</span></p>
                            <h1 style="font-size:22px;">{{ $projects->count() }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Completed</span></p>
                            <h1 style="font-size:22px;" id="">{{ $completed }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>In Progress</span></p>
                            <h1 style="font-size:22px;" id="">{{ $in_progress }}</h1>
                        </div>
                    </div>
                </div>
                
                


            </div>
            
            <form action="{{ route('reports.showJobDuration') }}" method="get">
                <div class="row mb-5 align-items-center">
                    
                    <div class="col-md-3">
                        <input required @if(!request()->has('from')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="From" name="from" value="@if(request()->has('from')){{request()->from}}@endif" />
                    </div>
                    <div class="col-md-3">
                        <input required @if(!request()->has('to')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="To" name="to" value="@if(request()->has('to')){{request()->to}}@endif" />
                    </div>
                    <div class="col-md-2">
                        <button class="btn w-100 btn-primary ">Filter</button>
                    </div>
                </div>
            </form>
            @if(!request()->has('from'))
            <p class=""><i>Showing results from past 90 days.</i></p>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body p-0">
                            <!--begin::Table-->
                            <table class="table table-bordered mb-0" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th>Reference</th>
                                            <th>Project Title</th>
                                            <th>Client</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Status</th>
                                            <th>Duration</th>
                                            <th>View</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold">
                                        @foreach($projects as $project)
                                        <tr>
                                            <td>WG-{{str_pad($project->id, 4, '0', STR_PAD_LEFT)}}</td>
                                            <td width="25%">{{ !empty($project->title) ? $project->title : 'Untitled' }}</td>
                                            <td>{{ $project->company_name }}</td>
                                            <td>{{ date('jS M Y', strtotime($project->created_at)) }}</td>
                                            <td>{{ $project->completed==1 ? date('jS M Y', strtotime($project->completion_date)) : '' }}</td>
                                            <td class="text-center">
                                                @if($project->completed==1)
                                                    <span class="text-primary">Completed</span>
                                                @else
                                                    <span class="text-danger">In Progress</span>
                                                @endif
                                            </td>
                                            <td>{{ $project->days }} Days</td>
                                            <td class="text-center">
                                                <a target="_blank" href="{{ route('project.details', ['id'=>$project->id]) }}"><i class="fas fa-eye text-dark"></i></a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>
@endsection

@section('js')
<script>
    
    $("#kt_daterangepicker_2").daterangepicker({
        timePicker: true,
        locale: {
            format: "DD-MM-Y",
            separator: ' / '
        },
        timePicker: false
    }, function(start, end) {
        $('#start-date').val(start.format('YYYY-MM-DD'));
        $('#end-date').val(end.format('YYYY-MM-DD'));
    });
    
    
    
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });
    


</script>
@endsection
