@extends('layouts.app')
@section('title', 'Work in Progress Report')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Sales invoices to be billed</span></p>
                            <h1 style="font-size:22px;">{{ $invoices->count() }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Sales invoices amount to be billed</span></p>
                            <h1 style="font-size:22px;" id="net_amount">0</h1>
                        </div>
                    </div>
                </div>
                
                


            </div>
            
            <form action="{{ route('reports.showWipReport') }}" method="get">
                <div class="row mb-5 align-items-center">
                    
                    <div class="col-md-3">
                        <input required @if(!request()->has('from')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="From" name="from" value="@if(request()->has('from')){{request()->from}}@endif" />
                    </div>
                    <div class="col-md-3">
                        <input required @if(!request()->has('to')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="To" name="to" value="@if(request()->has('to')){{request()->to}}@endif" />
                    </div>
                    <div class="col-md-2">
                        <button class="btn w-100 btn-primary ">Filter</button>
                    </div>
                </div>
            </form>
            @if(!request()->has('from'))
            <p class=""><i>Showing results from past 90 days.</i></p>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body p-0">
                            <!--begin::Table-->
                            <table class="table table-bordered mb-8" id="myTable">
                                    <thead>
                                        <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                            <th>Date</th>
                                            <th>Invoice</th>
                                            <th>Project</th>
                                            <th>Customer</th>
                                            <th>Status</th>
                                            <th>Net Amount</th>
                                            <th>View</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-600 fw-semibold">
                                        @php $net_amount = 0;  @endphp
                                        @foreach($invoices as $invoice)
                                        <tr>
                                            
                                            <td>{{ date('jS M Y', strtotime($invoice->created_at)) }}</td>
                                            <td>
                                                @if($invoice->credit_note==0)
                                                WGI-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}
                                                @else
                                                <span class="text-danger">WGC-{{str_pad($invoice->id, 4, '0', STR_PAD_LEFT);}}</span>
                                                @endif
                                            </td>
                                            <td>
                                                WG-{{str_pad($invoice->project_id, 4, '0', STR_PAD_LEFT);}}
                                            </td>
                                            <td>{{ $invoice->company_name }}</td>
                                            <td class="text-center">
                                                @if($invoice->sent_to_client==0)
                                                <span class="text-danger fw-bold">{{ ucfirst($invoice->status) }}</span>
                                                @else
                                                <span class="text-primary fw-bold">{{ ucfirst($invoice->status) }}</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                
                                                £{{ number_format($invoice->final_amount, 2) }}
                                            </td>
                                            <td class="text-center">
                                                <a target="_blank" href="{{ route('project.viewInvoice', ['id'=>$invoice->id]) }}"><i class="fas fa-eye text-dark"></i></a>
                                            </td>
                                        </tr>
                                            @php $net_amount += $invoice->final_amount;  @endphp
                                        @endforeach
                                    </tbody>
                                </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>
@endsection

@section('js')
<script>
    
    $("#net_amount").html('£{{ number_format($net_amount, 2) }}');
    $("#kt_daterangepicker_2").daterangepicker({
        timePicker: true,
        locale: {
            format: "DD-MM-Y",
            separator: ' / '
        },
        timePicker: false
    }, function(start, end) {
        $('#start-date').val(start.format('YYYY-MM-DD'));
        $('#end-date').val(end.format('YYYY-MM-DD'));
    });
    
    
    
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });
    


</script>
@endsection
