@extends('layouts.app')
@section('title', 'Gross Profit Margin')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <!--begin::Toolbar-->
    <style>
        .bg-danger-2 {
            background: #ffcccc;
            border-color: #ffcccc;
        }


        table.table-bordered.dataTable {
            border: 0;
            border-bottom: 0;
        }

        .bg-success-2 {
            background: #D2EA8E;
        }

        .text-red {
            color: red !important;
        }

        body,
        #kt_app_header {
            background: #f1f5f5 !important;
        }

        .table td,
        .table th {
            vertical-align: middle;
        }

        .table td {
            background: #93D5001A;
            border: 3px solid white !important;
            padding: 8px !important;
            color: black !important;
            text-align: center;
            color: #727879;
        }



        .table th {
            border: 3px solid white !important;
            background: #E3E3E3;
            color: #5E5E5E !important;
            font-weight: 500;
            font-size: 12px;
            margin: 10px !important;
            text-align: center;
        }

        table.dataTable.no-footer {
            border-bottom: 0 !important;
        }

    </style>
    <!--end::Toolbar-->
    <!--begin::Content-->
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            <!--begin::Row-->
            @if(session('success'))
            <div class="col-md-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
            @endif
            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif
            <div class="row g-5 g-xl-10 mb-xl-10">
                <div class="col-md-3">
                    <div class="card w-100">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Projects</span></p>
                            <h1 style="font-size:22px;">{{ $projects->count() }}</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Sales</span></p>
                            <h1 style="font-size:22px;" id="total_sales">0</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Estimated Profit</span></p>
                            <h1 style="font-size:22px;" id="total_estimated_profit">0</h1>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <p class="fw-bold"><span>Total Actual Profit</span></p>
                            <h1 style="font-size:22px;" id="total_actual_profit">0</h1>
                        </div>
                    </div>
                </div>


            </div>
            
            <div class="card g-5 g-xl-10 mb-xl-10 p-4">
                <div class="">
                    <div class="row">
                        <div class="col-md-6">
                            <div>
                                <div id="chartdiv" style="width: 100%; height: 400px;"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <div id="chartdiv2" style="width: 100%; height: 400px;"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <form action="{{ route('reports.showGrossProfitMarginReport') }}" method="get">
                <div class="row mb-5 align-items-center">
                    
                    <div class="col-md-3">
                        <input required @if(!request()->has('from')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="From" name="from" value="@if(request()->has('from')){{request()->from}}@endif" />
                    </div>
                    <div class="col-md-3">
                        <input required @if(!request()->has('to')) onfocus="this.type='date'" onblur="if(this.value===''){this.type='text'}" @else type="date" @endif class="form-control  bg-white" placeholder="To" name="to" value="@if(request()->has('to')){{request()->to}}@endif" />
                    </div>
                    <div class="col-md-2">
                        <button class="btn w-100 btn-primary ">Filter</button>
                    </div>
                </div>
            </form>
            
            @if(!request()->has('from'))
            <p class=""><i>Showing results from past 90 days.</i></p>
            @endif
            
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <!--begin::Card header-->
                        
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body p-0">
                            <!--begin::Table-->
                            
                            
                            
                            
                            <table class="table table-bordered mb-0" id="kt_table_users">
                                <thead>
                                    <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">
                                        <th class="min-w-125px" style="text-align:left">Project</th>
                                        <th class="min-w-100px">Total Sales</th>
                                        <th class="min-w-100px">Estimated Gross Profit</th>
                                        <th class="min-w-100px">Actual Gross Profit</th>
                                    </tr>
                                </thead>
                                <tbody class="">
                                   
                                    @php 
                                        $grand_sales = 0;
                                        $grand_estimated_profit = 0;
                                        $grand_actual_profit = 0;
                                        $months = ['09-2024', '10-2024', '11-2024'];
                                        $result = array_fill_keys($months, [
                                            'project_ids' => [],
                                            'sales_net' => 0,
                                            'estimated_profit' => 0,
                                            'actual_profit' => 0,
                                        ]);
                                    @endphp
                                   
                                    @foreach($projects as $project)
                                        @php
                                            $plant = 0;
                                            $labour = 0;
                                            $material = 0;
                                            $subcontract = 0;
                                            $other = 0;
                                            $sales_net = 0;
                                            $sub_contracts_total = 0;
                                            $sub_contracts_other_total = 0;
                                            $estimated_net = 0;
                                            $po_total_plant = 0;
                                            $po_total_material = 0;
                                            $po_total_labour = 0;
                                            $po_total = 0;
                                            $estimated_gross_profit = 0;
                                            $actual_gross_profit = 0;
                                            
                                            
                                            
                                            
                                        @endphp
                                        @if($project->tender==1)
                                            <?php
                                                 foreach($project->tenderItems as $ti){
                                                    $plant += $ti->plant;
                                                    $labour += $ti->labour;
                                                    $material += $ti->material;
                                                    $subcontract += $ti->sub_contract;
                                                    $other += $ti->other;
                                                 }
                                                 
                                                $sales_net = $plant+$labour+$material+$subcontract+$other;
                                                
                                                $plant_estimated = $plant*0.60;
                                                $labour_estimated = $labour*0.60;
                                                $material_estimated = $material*0.60;
                                                $subcontract_estimated = ($subcontract*0.60-$sub_contracts_total);
                                                $other_estimated = ($other*0.60-$sub_contracts_other_total);
                                    
                                                $estimated_net = $plant_estimated+$labour_estimated+$material_estimated+$subcontract_estimated+$other_estimated;
                                                
                                                foreach($project->sub_contracts as $sc){
                                                    if($sc->type=='sub_contract'){
                                                        $sub_contracts_total+=$sc->amount;
                                                    }

                                                    if($sc->type=='other'){
                                                        $sub_contracts_other_total+=$sc->amount;
                                                    }
                                                }
                                    
                                            
                                                foreach($project->purchase_orders as $po){
                                                    $po_total += $po->total;
                                                }
                                    
                                                $estimated_gross_profit = $sales_net-$estimated_net;
                                                $actual_gross_profit = $sales_net - ($estimated_net + $po_total);
                                    
                                                $grand_sales += $sales_net;
                                                $grand_estimated_profit += $estimated_gross_profit;
                                                $grand_actual_profit += $actual_gross_profit;
                                    
                                    
                                            ?>
                                        @else
                                        
                                            <?php
                                                foreach($project->items as $item){
                                                    $plant += $item->plant*$item->quantity;
                                                    $labour += $item->labour*$item->quantity;
                                                    $material += $item->material*$item->quantity;
                                                 }
                                    
                                                foreach($project->purchase_orders as $po){
                                                    $po_total += $po->total;
                                                }
                                    
                                                 $sales_net = $plant+$labour+$material;
                                                 $plant_estimated = $plant*0.60;
                                                 $labour_estimated = $labour*0.60;
                                                 $material_estimated = $material*0.60;
                                    
                                                 $estimated_net = $plant_estimated+$labour_estimated+$material_estimated;
                                                $estimated_gross_profit = $sales_net-$estimated_net;
                                                $actual_gross_profit = $sales_net - ($estimated_net + $po_total);
                                    
                                    
                                                $grand_sales += $sales_net;
                                                $grand_estimated_profit += $estimated_gross_profit;
                                                $grand_actual_profit += $actual_gross_profit;
                                        ?>
                                        @endif
                                        
                                        <?php
                                            $createdDate = \Carbon\Carbon::parse($project->created_at);
                                            $monthYear = $createdDate->format('m-Y'); // Format to match your months array

                                            // Check if the monthYear exists in the months array
                                            if (array_key_exists($monthYear, $result)) {
                                                // Add the project ID to the corresponding month in the result
                                                $result[$monthYear]['project_ids'][] = $project->id;
                                                // Sum the sales_net, estimated_profit, and actual_profit
                                                $result[$monthYear]['sales_net'] += $sales_net;
                                                $result[$monthYear]['estimated_profit'] += $estimated_gross_profit;
                                                $result[$monthYear]['actual_profit'] += $actual_gross_profit;
                                            }
                                    
                                        ?>
                                        
                                    
                                    <tr>
                                        <td width="40%" style="text-align:left;"><a target="_blank" class="text-dark" href="{{route('projects.financials', ['id'=>$project->id])}}">WG-{{ str_pad($project->id, 4, '0', STR_PAD_LEFT) }} &#8226; {{ !empty($project->title) ? $project->title : 'Untitled' }}</a></td>
                                        <td width="20%">£{{ number_format($sales_net, 2) }}</td>
                                        <td width="20%">£{{ number_format($estimated_gross_profit, 2) }}</td>
                                        <td width="20%">£{{ number_format($actual_gross_profit, 2) }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <?php
                                $result = array_filter($result, function ($monthData) {
                                    return !empty($monthData['project_ids']);
                                });
                                //echo "<pre>";
                                //print_r($result);
                            ?>
                            
                            
                            
                            <!--end::Table-->
                        </div>
                        <!--end::Card body-->
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="uploadPdfModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form enctype="multipart/form-data" method="POST" class="form" action="{{ route('hr.uploadHandbook') }}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Upload PDF</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    
                    
                    
                    <div class="d-flex flex-column mb-8  fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Document</span>
                        </label>
                        <!--end::Label-->
                        <input type="file" class="form-control" name="document" required>
                    </div>
                    
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@endsection
@section('js')
<script src="https://cdn.amcharts.com/lib/5/index.js"></script>
<script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
<script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
<script>
    
    <?php
        // Data preparation for AmCharts
        $chartData = [];
        foreach ($result as $month => $data) {
            $chartData[] = [
                'month' => $month,
                'sales_net' => $data['sales_net'],
                'estimated_profit' => $data['estimated_profit'],
                'actual_profit' => $data['actual_profit'],
            ];
        }
    ?>
    
    // Parse PHP data into JavaScript
    const chartData = <?php echo json_encode($chartData); ?>;

    // Create chart
    am5.ready(function() {
        // Create root element
        var root = am5.Root.new("chartdiv");

        // Set themes
        root.setThemes([am5themes_Animated.new(root)]);

        // Create chart
        var chart = root.container.children.push(
            am5xy.XYChart.new(root, {
                layout: root.verticalLayout
            })
        );

        // Create X-axis (Months)
        var xAxis = chart.xAxes.push(
            am5xy.CategoryAxis.new(root, {
                categoryField: "month",
                renderer: am5xy.AxisRendererX.new(root, { minGridDistance: 30 }),
                 
            })
        );
        xAxis.data.setAll(chartData);

        // Create Y-axis (Values)
        var yAxis = chart.yAxes.push(
            am5xy.ValueAxis.new(root, {
                renderer: am5xy.AxisRendererY.new(root, {}),
                min: 0 // Start the Y-axis at 0 to avoid negatives
            })
        );

        // Add series for Sales Net
        var salesNetSeries = chart.series.push(
            am5xy.ColumnSeries.new(root, {
                name: "Sales Net",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "sales_net",
                categoryXField: "month",
                fill: am5.color("#4CAF50"),
                stroke: am5.color("#4CAF50"),
            })
        );
        salesNetSeries.data.setAll(chartData);

        // Add series for Estimated Profit
        var estimatedProfitSeries = chart.series.push(
            am5xy.ColumnSeries.new(root, {
                name: "Estimated Profit",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "estimated_profit",
                categoryXField: "month",
                fill: am5.color("#FF9800"),
                stroke: am5.color("#FF9800"),
            })
        );
        estimatedProfitSeries.data.setAll(chartData);

        // Add series for Actual Profit
        var actualProfitSeries = chart.series.push(
            am5xy.ColumnSeries.new(root, {
                name: "Actual Profit",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "actual_profit",
                categoryXField: "month",
                fill: am5.color("#673AB7"),
                stroke: am5.color("#673AB7"),
            })
        );
        actualProfitSeries.data.setAll(chartData);

        // Add legend
        var legend = chart.children.push(
            am5.Legend.new(root, {})
        );
        legend.data.setAll(chart.series.values);

        // Animate chart on load
        chart.appear(1000, 100);
    }); // end am5.ready()
    
    
    am5.ready(function() {
    // Create root element
    var root = am5.Root.new("chartdiv2");

    // Set themes
    root.setThemes([am5themes_Animated.new(root)]);

    // Create chart
    var chart = root.container.children.push(
        am5xy.XYChart.new(root, {
            layout: root.verticalLayout
        })
    );

    // Create X-axis (Months)
    var xAxis = chart.xAxes.push(
        am5xy.CategoryAxis.new(root, {
            categoryField: "month",
            renderer: am5xy.AxisRendererX.new(root, { minGridDistance: 30 })
        })
    );
    xAxis.data.setAll(chartData);

    // Create Y-axis (Values)
    var yAxis = chart.yAxes.push(
        am5xy.ValueAxis.new(root, {
            renderer: am5xy.AxisRendererY.new(root, {}),
            min: 0 // Ensure the Y-axis starts at 0
        })
    );

    // Add series for Sales Net
    var salesNetSeries = chart.series.push(
        am5xy.LineSeries.new(root, {
            name: "Sales Net",
            xAxis: xAxis,
            yAxis: yAxis,
            valueYField: "sales_net",
            categoryXField: "month",
            stroke: am5.color("#4CAF50"), // Line color
            fill: am5.color("#4CAF50")
        })
    );
    salesNetSeries.strokes.template.set("strokeWidth", 2); // Line thickness
    salesNetSeries.bullets.push(() =>
        am5.Bullet.new(root, {
            sprite: am5.Circle.new(root, {
                radius: 5,
                fill: salesNetSeries.get("fill")
            })
        })
    );
    salesNetSeries.data.setAll(chartData);

    // Add series for Estimated Profit
    var estimatedProfitSeries = chart.series.push(
        am5xy.LineSeries.new(root, {
            name: "Estimated Profit",
            xAxis: xAxis,
            yAxis: yAxis,
            valueYField: "estimated_profit",
            categoryXField: "month",
            stroke: am5.color("#FF9800"),
            fill: am5.color("#FF9800")
        })
    );
    estimatedProfitSeries.strokes.template.set("strokeWidth", 2);
    estimatedProfitSeries.bullets.push(() =>
        am5.Bullet.new(root, {
            sprite: am5.Circle.new(root, {
                radius: 5,
                fill: estimatedProfitSeries.get("fill")
            })
        })
    );
    estimatedProfitSeries.data.setAll(chartData);

    // Add series for Actual Profit
    var actualProfitSeries = chart.series.push(
        am5xy.LineSeries.new(root, {
            name: "Actual Profit",
            xAxis: xAxis,
            yAxis: yAxis,
            valueYField: "actual_profit",
            categoryXField: "month",
            stroke: am5.color("#673AB7"),
            fill: am5.color("#673AB7")
        })
    );
    actualProfitSeries.strokes.template.set("strokeWidth", 2);
    actualProfitSeries.bullets.push(() =>
        am5.Bullet.new(root, {
            sprite: am5.Circle.new(root, {
                radius: 5,
                fill: actualProfitSeries.get("fill")
            })
        })
    );
    actualProfitSeries.data.setAll(chartData);

    // Add legend
    var legend = chart.children.push(
        am5.Legend.new(root, {})
    );
    legend.data.setAll(chart.series.values);

    // Animate chart on load
    chart.appear(1000, 100);
}); // end am5.ready()

    
    $("#upload_pdf").click(function() {
        $("#uploadPdfModal").modal("show");
    });
    
    $("#total_sales").html('£{{ number_format($grand_sales, 2) }}');
    $("#total_estimated_profit").html('£{{ number_format($grand_estimated_profit, 2) }}');
    $("#total_actual_profit").html('£{{ number_format($grand_actual_profit, 2) }}');

</script>
@endsection