@extends('layouts.app')
@section('title', 'Users')

@section('content')

<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }

</style>

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Edit User Details</h1>
                </div>
                <a href="{{route('settings.users')}}" class="btn btn-primary btn-sm">Go Back</a>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" class="form" action="{{route('settings.updateUser', ['id'=>$user->id])}}">
                                <!--begin::Heading-->
                                @csrf
                               
                                <!--end::Heading-->
                                <!--begin::Input group-->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">First Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter First Name" name="firstname" value="{{$user->firstname}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Last Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Last Name" name="lastname" value="{{$user->lastname}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Email</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="email" class="form-control " placeholder="Enter Email" name="email" value="{{$user->email}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Phone</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Phone" name="phone" value="{{$user->phone}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Department</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="department" class="form-select" id="department" required>
                                                <option value="">Select</option>
                                                <option value="contracts_manager">Contracts Manager</option>
                                                <option value="site_manager">Site Manager</option>
                                                <option value="labourer">Labourer</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Office Location</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="office_location" class="form-select" id="office_location" required>
                                                <option value="">Select</option>
                                                @foreach($offices as $office)
                                                    <option value="{{ $office->id }}">{{ $office->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                @if($user->department=='site_manager')
                                <div class="row mb-8">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column  fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Skills Set</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="skills_set[]" multiple class="form-select" id="skills_set">
                                                @foreach($skills as $skill)
                                                    <option @if(in_array($skill->id, $user_skills)) selected @endif value="{{ $skill->id }}">{{ $skill->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-8">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column  fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Select Labourer</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="labourers[]" class="form-select" id="labourer">
                                                @foreach($labourers as $labourer)
                                                    <option @if(in_array($labourer->id, $user_labourers)) selected @endif value="{{ $labourer->id }}">{{ $labourer->firstname }} {{ $labourer->lastname }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Manager</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="manager_id" class="form-select" required id="manager_id">
                                                <option value="">Select</option>
                                                @foreach($managers as $manager)
                                                    <option value="{{ $manager->id }}">{{ $manager->firstname }} {{ $manager->lastname }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row mb-8">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column  fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Project Types Access</span>
                                            </label>
                                            <!--end::Label-->
                                            <select name="project_types[]" multiple class="form-select" id="project_types">
                                                @php
                                                      $selected = explode(',', $user->project_types_access);
                                                @endphp
                                                <option @if(in_array(0, $selected)) selected @endif value="0" selected>All Project Types</option>
                                                
                                                
                                                
                                                
                                                @foreach($project_types as $type)
                                                    <option @if(in_array($type->id, $selected)) selected @endif value="{{ $type->id }}">{{ $type->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-8">
                                    <div class="col-md-6">
                                        <div class="form-check me-2">
                                            <input @if($user->third_party==1) checked @endif name="third_party" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault90" />
                                            <label class="form-check-label" for="flexCheckDefault90">
                                                Third Party Contractor
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-8">
                                    <div class="col-md-12">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="">Permissions</span>
                                        </label>
                                    </div>
                                    <div class="col-md-12 mb-2">
                                        <div>
                                            <div class="form-check-cover form-check-inline ">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_dashboard==1) checked @endif name="dashboard" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault" />
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        Dashboard
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_crm==1) checked @endif name="crm" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault2" />
                                                    <label class="form-check-label" for="flexCheckDefault2">
                                                        CRM
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_projects==1) checked @endif name="projects" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault3" />
                                                    <label class="form-check-label" for="flexCheckDefault3">
                                                        Projects
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_planning==1) checked @endif name="planning" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault4" />
                                                    <label class="form-check-label" for="flexCheckDefault4">
                                                        Planning
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_accounts==1) checked @endif name="accounts" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault5" />
                                                    <label class="form-check-label" for="flexCheckDefault5">
                                                        Accounts
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_reports==1) checked @endif name="reports" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault6" />
                                                    <label class="form-check-label" for="flexCheckDefault6">
                                                        Reports Dashboard
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_system==1) checked @endif name="system" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault7" />
                                                    <label class="form-check-label" for="flexCheckDefault7">
                                                        System
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_app_access==1) checked @endif name="app_access" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault8" />
                                                    <label class="form-check-label" for="flexCheckDefault8">
                                                        App Access
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->perm_timesheet==1) checked @endif name="timesheet" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault9" />
                                                    <label class="form-check-label" for="flexCheckDefault9">
                                                        Time Sheet
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-check-cover form-check-inline">
                                                <div class="form-check me-2">
                                                    <input @if($user->manager_access==1) checked @endif name="manager_access" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault10" />
                                                    <label class="form-check-label" for="flexCheckDefault10">
                                                        Manager Access
                                                    </label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>


                                </div>





                                <div class="text-end">
                                    
                                    <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                        Update

                                    </button>
                                </div>
                                <!--end::Actions-->
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>



@endsection


@section('js')
<script>
    
    $("#manager_id").val("{{$user->manager_id}}")
    
    $('#project_types').select2();
    $('#skills_set').select2();
    $('#labourer').select2();
    
    
    $("#department").val('{{$user->department}}');
    $("#office_location").val('{{$user->office_location}}');


    $(".form-check-input").change(function() {
        if ($(this).is(":checked")) {
            $(this).parent().parent().addClass('active');
        } else {
            $(this).parent().parent().removeClass('active');
        }
    })

    

</script>
@endsection
