@extends('layouts.app')
@section('title', 'Financial Items')

@section('content')
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Financial Items</h1>

                </div>
                <div class="ms-3 float-end">
                    <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-primary btn-sm">Add New Item</button>
                </div>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <!--begin::Search-->
                        <div class="d-flex align-items-center justify-between position-relative my-1">
                            <i class="ki-outline ki-magnifier fs-3 position-absolute ms-5"></i>
                            <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-13" placeholder="Search" id="mySearch" />

                        </div>

                        <!--end::Search-->
                    </div>
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->

                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body py-4">
                    <!--begin::Table-->
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                        <thead>
                            <tr class="text-start text-muted fw-bold fs-7 text-uppercase gs-0">

                                <th class="">Code / Desc.</th>
                                <th class="">UoM</th>
                                <th class="">Plant</th>
                                <th class="">Label</th>
                                <th class="">Material</th>
                                <th class="">Sales Price</th>
                                <th class="">Qty</th>
                                
                                <th class="">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600 fw-semibold">
                            @foreach($items as $item)
                            <tr>

                                <td>
                                    <b><span class="tr_code">{{ $item->code }}</span></b><br> 
                                    <small class="tr_description">{{ $item->description }}</small>
                                </td>
                                <td> <span class="tr_uom">{{ $item->uom }}</span> </td>
                                <td> £<span class="tr_plant">{{ number_format($item->plant, 2) }}</span> </td>
                                <td> £<span class="tr_labour">{{ number_format($item->labour, 2) }}</span> </td>
                                <td> £<span class="tr_material">{{ number_format($item->material, 2) }}</span> </td>
                                <td> £<span class="tr_sales_price">{{ number_format($item->sales_price, 2) }}</span> </td>
                                <td> {{ $item->quantity }} </td>
                                
                                <td class="">
                                    <a href="#" class="btn btn-light btn-active-light-primary btn-flex btn-center btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
                                        <i class="ki-outline ki-down fs-5 ms-1"></i></a>
                                    <!--begin::Menu-->
                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-4" data-kt-menu="true">
                                        <div class="menu-item px-3">

                                            <a href="#!" class="menu-link edit px-3" data-id="{{$item->id}}">Edit</a>
                                            <a href="#!" class="menu-link px-3 delete" data-id="{{$item->id}}">Delete</a>
                                        </div>

                                    </div>
                                    <!--end::Menu-->
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!--end::Table-->
                </div>
                <!--end::Card body-->
            </div>
        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('settings.addFinancialItem')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New Item</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Code</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Code" name="code" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Description</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control " placeholder="Enter Description" name="description" />
                    </div>

                    
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Sales Price</span>
                        </label>
                        <!--end::Label-->
                        <input required type="number" class="form-control " placeholder="" name="sales_price" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Quantity</span>
                        </label>
                        <!--end::Label-->
                        <input required type="number" class="form-control " placeholder="" name="quantity" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Select Uom</span>
                        </label>
                        <!--end::Label-->
                        <select required name="uom" class="form-select" id="add_uom" data-placeholder="Select">
                            <option>Select</option>
                            @foreach($uoms as $uom)
                            <option value="{{$uom->name}}">{{$uom->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('settings.updateFinancials')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Edit Financial Item</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Code</span>
                        </label>
                        <!--end::Label-->
                        <input required type="text" class="form-control" id="e_code" placeholder="Enter Code" name="code" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Description</span>
                        </label>
                        <!--end::Label-->
                        <textarea name="description" class="form-control" id="e_description" cols="30" rows="3"></textarea>
                    </div>
                        
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Plant</span>
                        </label>
                        <!--end::Label-->
                        <input required type="number" step="any" class="form-control" id="e_plant" placeholder="" name="plant" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Labour</span>
                        </label>
                        <!--end::Label-->
                        <input required type="number" step="any" class="form-control" id="e_labour" placeholder="" name="labour" />
                    </div>
                    <div class="d-flex flex-column mb-8 fv-row">
                        <!--begin::Label-->
                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                            <span class="required">Material</span>
                        </label>
                        <!--end::Label-->
                        <input required type="number" step="any" class="form-control" id="e_material" placeholder="" name="material" />
                        <input type="hidden" name="item_id" id="e_id">
                    </div>
                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>

<form action="{{ route('settings.deleteFinancialItems') }}" method="post" id="deleteForm">
    @csrf
    <input type="hidden" name="delete_id" id="delete_id">
</form>


@endsection


@section('js')
<script>
    
    $(document).on('click', '.delete', function(){
        var id = $(this).data('id');
        $("#delete_id").val(id);
        if(confirm('Are you sure?')){
            $("#deleteForm").submit();
        }
    });
    
    $(".edit").click(function() {
        var $row = $(this).closest('tr');
        var id = $(this).data('id');
        $("#e_code").val($row.find('.tr_code').text());
        $("#e_description").val($row.find('.tr_description').text());
        $("#e_labour").val($row.find('.tr_labour').text());
        $("#e_material").val($row.find('.tr_material').text());
        $("#e_plant").val($row.find('.tr_plant').text());
        $("#e_id").val(id);
        $("#editModal").modal("show");
    });

    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    });

</script>
@endsection
