@extends('layouts.app')
@section('title', 'Profile')

@section('content')
<link rel="stylesheet" href="https://foliotek.github.io/Croppie/croppie.css">
<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }
    
    .user-img{
        border-radius: 50%;
        width: 150px;
        height: 150px;
    }

</style>

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Profile</h1>
                </div>

            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if ($errors->any())
            <div class="alert alert-danger">
                {!! implode('<br>', $errors->all(':message')) !!}
            </div>
            @endif

            <div class="row">
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <div class=" overflow-hidden ">
                                <div class="symbol-label text-center">
                                    <span style="position:absolute;right:15px;top:15px;cursor:pointer"><i class="fa fa-edit" style="font-size:18px" onclick="$('#select_logo').trigger('click');"></i></span>
                                    <img src="{{asset('img/users/'.$user->image)}}" class=" user-img" />
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="card mb-8">
                        <div class="card-header " id="kt_chat_contacts_header">
                            <div class="card-title justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold">Details</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST" class="form" action="{{route('update.profile')}}">
                                <!--begin::Heading-->
                                @csrf

                                <!--end::Heading-->
                                <!--begin::Input group-->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">First Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter First Name" name="firstname" value="{{$user->firstname}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Last Name</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Last Name" name="lastname" value="{{$user->lastname}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Email</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="email" class="form-control " placeholder="Enter Email" name="email" value="{{$user->email}}" />
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Phone</span>
                                            </label>
                                            <!--end::Label-->
                                            <input required type="text" class="form-control " placeholder="Enter Phone" name="phone" value="{{$user->phone}}" />
                                        </div>
                                    </div>
                                </div>







                                <div class="text-end">

                                    <button type="submit" id="" class="btn btn-primary">
                                        Update

                                    </button>
                                </div>
                                <!--end::Actions-->
                            </form>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header " id="kt_chat_contacts_header">
                            <div class="card-title justify-content-between">
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold">Update Password</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST" class="form" action="{{ route('update.password') }}">
                                <!--begin::Heading-->
                                @csrf

                                <!--end::Heading-->
                                <!--begin::Input group-->
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Current Password</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="password" name="current_password" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">New Password</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="password" name="new_password" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex flex-column mb-8 fv-row">
                                            <!--begin::Label-->
                                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                                <span class="required">Confirm New Password</span>
                                            </label>
                                            <!--end::Label-->
                                            <input type="password" name="new_password_confirmation" class="form-control" required>
                                        </div>
                                    </div>

                                </div>







                                <div class="text-end">

                                    <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                        Update

                                    </button>
                                </div>
                                <!--end::Actions-->
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="cropImagePop" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content rounded">
            <div class="modal-header pb-0 border-0 justify-content-end">
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
            </div>
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <div class="">
                    <center>
                        <div class="form-group">
                            <label for="" style="font-size:20px;margin-bottom:15px;">Crop Image</label>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-12">
                               <div id="croppie-container">
                                <div id="croppie"></div>
                                </div>
                            </div>
                        </div>
                    </center>
                    <div class="mb-3">
                        <center>
                            <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                            <button type="button" id="cropImageBtn" class="btn btn-primary">Upload</button>
                        </center>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<input type="file" style="display:none" id="select_logo">

@endsection


@section('js')
<script src="https://foliotek.github.io/Croppie/croppie.js"></script>
<script>
    
    var image = "";
    
    function initCroppie(img){
        image = img;
        $("#cropImagePop").modal("show");
    }
    
    var croppieInstance;
    
    $('#cropImagePop').on('shown.bs.modal', function () {
        croppieInstance = $('#croppie').croppie({
            viewport: { width: 200, height: 200 },
            boundary: { width: 300, height: 300 },
            showZoomer: true
        });
        
        croppieInstance.croppie('bind', {
            url: image,
        }).then(function () {
            console.log('Image successfully loaded into Croppie');

            // Show the Croppie container after binding the image
            $('#cropImagePop').modal('show');
        });
    });
    
    $(document).ready(function () {
        $('#select_logo').on('change', function () {
            var reader = new FileReader();
            reader.onload = function (e) {
                initCroppie(e.target.result);
            }
            reader.readAsDataURL(this.files[0]);
        });
    });
    
    $('#cropImageBtn').on('click', function(ev) {
        croppieInstance.croppie('result', {
            type: 'base64',
            format: 'jpeg',
            size: {
                width: 250,
                height: 250
            }
        }).then(function(resp) {
            $.ajax({
                url: "{{ route('settings.uploadUserImage', ['id'=>$user->id]) }}",
                type: "POST",
                data: {
                    image: resp,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                    $(".user-img").attr('src', '{{ asset("img/users") }}' +'/'+ data.image_url);
                    $('#cropImagePop').modal('hide');
                }
            });
        });
    });


    $("#manager_id").val("{{$user->manager_id}}")

    $('#project_types').select2();
    $('#skills_set').select2();
    $('#labourer').select2();


    $("#department").val('{{$user->department}}');
    $("#office_location").val('{{$user->office_location}}');


    $(".form-check-input").change(function() {
        if ($(this).is(":checked")) {
            $(this).parent().parent().addClass('active');
        } else {
            $(this).parent().parent().removeClass('active');
        }
    })

</script>
@endsection
