@extends('layouts.app')
@section('title', 'Users')

@section('content')

<style>
    .form-check-label {
        font-size: 15px;
        color: black;
    }

    .form-check-cover {
        margin-bottom: 10px;
        padding: 8px;
        border-radius: 8px;
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.94), rgba(255, 255, 255, 0.94)), #5E5E5E;
    }

    .form-check-cover.active {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), #93D500;
    }

    .form-check-input:checked {
        border-color: #93d500;
    }

    .user-data.form-control {
        background: white;
        border-color: #ddd;
    }

    .badge {
        font-size: 16px;
        font-weight: 400;
        padding: 8px;
        color: black;
    }

    .card-footer {
        background: linear-gradient(0deg, rgba(255, 255, 255, 0.9), rgba(255, 255, 255, 0.9)), #93D500 !important;
    }
    


</style>

<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-7 pt-lg-10">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <!--begin::Toolbar wrapper-->
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">Users</h1>

                </div>
                <div class="ms-3 float-end">
                    <button data-bs-toggle="modal" data-bs-target="#kt_modal_new_target" class="btn btn-primary btn-sm">Add New User</button>
                </div>
            </div>
            <!--end::Toolbar wrapper-->
        </div>
        <!--end::Toolbar container-->
    </div>
    <div id="kt_app_content" class="app-content flex-column-fluid">
        <!--begin::Content container-->
        <div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            <div class="row">
                @foreach($users as $user)
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <!--begin::Author-->
                            <div class="d-flex align-items-center">
                                <!--begin::Avatar-->
                                <div class="symbol symbol-50px me-5">
                                    <img src="{{asset('img/default.png')}}" class="" alt="">
                                </div>
                                <!--end::Avatar-->
                                <!--begin::Info-->
                                <div class="flex-grow-1">
                                    <!--begin::Name-->
                                    <a href="#" class="text-gray-800 text-hover-primary fs-4 fw-bold">{{$user->firstname}} {{$user->lastname}}</a>
                                    <!--end::Name-->
                                    <!--begin::Date-->
                                    <span class="text-gray-500 fw-semibold d-block">
                                        @if($user->department=='contracts_manager')
                                        Contracts Manager
                                        @else
                                        Site Manager
                                        @endif
                                    </span>
                                    <!--end::Date-->
                                </div>
                                
                                <!--end::Info-->
                            </div>
                            <span class="edit-btn" style="position:absolute;right:15px;top:15px;"><a href="{{route('settings.editUser', ['id'=>$user->id])}}"><i class="ki-outline fs-2 ki-notepad-edit"></i></a></span>
                            
                        </div>
                        <div class="card-body">
                            <div class="user-data form-control mb-3">
                                {{$user->email}} <span class="float-end"> <i class="ki-outline ki-sms fs-1 me-2"></i></span>
                            </div>
                            <div class="user-data form-control mb-3">
                                {{$user->phone}} <span class="float-end"> <i class="ki-outline ki-phone fs-1 me-2"></i></span>
                            </div>
                            <div class="user-data form-control">
                                London <span class="float-end"> <i class="ki-outline ki-map fs-1 me-2"></i></span>
                            </div>
                        </div>
                        <div class="card-footer">
                            @if($user->perm_dashboard==1)
                            <span class="badge badge-primary mb-3">Dashboard</span>
                            @endif

                            @if($user->perm_crm==1)
                            <span class="badge badge-primary mb-3">CRM</span>
                            @endif

                            @if($user->perm_projects==1)
                            <span class="badge badge-primary mb-3">Projects</span>
                            @endif

                            @if($user->perm_planning==1)
                            <span class="badge badge-primary mb-3">Planning</span>
                            @endif

                            @if($user->perm_accounts==1)
                            <span class="badge badge-primary mb-3">Accounts</span>
                            @endif

                            @if($user->perm_reports==1)
                            <span class="badge badge-primary mb-3">Reports</span>
                            @endif

                            @if($user->perm_system==1)
                            <span class="badge badge-primary mb-3">System</span>
                            @endif

                            @if($user->perm_app_access==1)
                            <span class="badge badge-primary mb-3">App Access</span>
                            @endif

                            @if($user->perm_timesheet==1)
                            <span class="badge badge-primary mb-3">Timesheet</span>
                            @endif

                        </div>
                    </div>
                </div>
                @endforeach
            </div>

        </div>
    </div>
    <!--end::Content-->
</div>

<div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog  mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content rounded">
            <!--begin::Modal header-->
            <div class="modal-header pb-0 border-0 justify-content-end">
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <i class="ki-outline ki-cross fs-1"></i>
                </div>
                <!--end::Close-->
            </div>
            <!--begin::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                <!--begin:Form-->
                <form method="POST" class="form" action="{{route('settings.addStaff')}}">
                    <!--begin::Heading-->
                    @csrf
                    <div class="mb-13 text-center">
                        <!--begin::Title-->
                        <h1 class="mb-3">Add New User</h1>
                        <!--end::Title-->
                        <!--begin::Description-->

                        <!--end::Description-->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">First Name</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" class="form-control " placeholder="Enter First Name" name="firstname" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Last Name</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" class="form-control " placeholder="Enter Last Name" name="lastname" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Email</span>
                                </label>
                                <!--end::Label-->
                                <input required type="email" class="form-control " placeholder="Enter Email" name="email" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Phone</span>
                                </label>
                                <!--end::Label-->
                                <input required type="text" class="form-control " placeholder="Enter Phone" name="phone" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Department</span>
                                </label>
                                <!--end::Label-->
                                <select name="department" class="form-select" id="" required>
                                    <option value="">Select</option>
                                    <option value="contracts_manager">Contracts Manager</option>
                                    <option value="site_manager">Site Manager</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-8 fv-row">
                                <!--begin::Label-->
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Office Location</span>
                                </label>
                                <!--end::Label-->
                                <select name="office_location" class="form-select" id="" required>
                                    <option value="">Select</option>
                                    <option value="1">London</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-8">
                        <div class="col-md-12">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="">Permissions</span>
                            </label>
                        </div>
                        <div class="col-md-12 mb-2">
                            <div>
                                <div class="form-check-cover form-check-inline ">
                                    <div class="form-check me-2">
                                        <input name="dashboard" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault" />
                                        <label class="form-check-label" for="flexCheckDefault">
                                            Dashboard
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="crm" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault2" />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            CRM
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="projects" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault3" />
                                        <label class="form-check-label" for="flexCheckDefault3">
                                            Projects
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="planning" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault4" />
                                        <label class="form-check-label" for="flexCheckDefault4">
                                            Planning
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="accounts" class="form-check-input" type="checkbox" value="" id="flexCheckDefault5" />
                                        <label class="form-check-label" for="flexCheckDefault5">
                                            Accounts
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="reports" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault6" />
                                        <label class="form-check-label" for="flexCheckDefault6">
                                            Reports Dashboard
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="system" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault7" />
                                        <label class="form-check-label" for="flexCheckDefault7">
                                            System
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="app_access" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault8" />
                                        <label class="form-check-label" for="flexCheckDefault8">
                                            App Access
                                        </label>
                                    </div>
                                </div>

                                <div class="form-check-cover form-check-inline">
                                    <div class="form-check me-2">
                                        <input name="timesheet" class="form-check-input" type="checkbox" value="1" id="flexCheckDefault9" />
                                        <label class="form-check-label" for="flexCheckDefault9">
                                            Time Sheet
                                        </label>
                                    </div>
                                </div>

                            </div>
                        </div>


                    </div>





                    <div class="text-center">
                        <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                            Submit

                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end:Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>


@endsection


@section('js')
<script>
    var table = $("#kt_table_users").DataTable({
        "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
        "paging": false, //Dont want paging                
        "bPaginate": false, //Dont want paging
    });


    $(".form-check-input").change(function() {
        if ($(this).is(":checked")) {
            $(this).parent().parent().addClass('active');
        } else {
            $(this).parent().parent().removeClass('active');
        }
    })

    $('#mySearch').on('input', function() {
        table.search($(this).val()).draw();
    })

</script>
@endsection
