<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiControllers\AuthController;
use App\Http\Controllers\ApiControllers\ProjectController;
use App\Http\Controllers\ApiControllers\HrController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login', [AuthController::class, 'login']);



Route::middleware('auth:sanctum')->group(function () {
    
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    
    //Project Endpoints
    Route::get('projects', [ProjectController::class, 'getProjects']);
    Route::get('projects/my', [ProjectController::class, 'getMyProjects']);
    Route::get('project/{id}/general', [ProjectController::class, 'getGeneralDetails']);
    Route::get('project/{id}/timesheet', [ProjectController::class, 'getTimesheet']);
    Route::post('project/{id}/add-timesheet', [ProjectController::class, 'addTimesheet']);
    Route::get('project/{id}/documents', [ProjectController::class, 'getDocuments']);
    Route::post('project/{id}/add-document', [ProjectController::class, 'addDocument']);
    Route::get('project/{id}/photos', [ProjectController::class, 'getPhotos']);
    Route::post('project/{id}/add-photo', [ProjectController::class, 'addPhoto']);
    Route::get('project/{id}/expenses', [ProjectController::class, 'getExpenses']);
    Route::post('project/{id}/generate-po', [ProjectController::class, 'generatePo']);
    Route::get('project/{id}/po/{po_id}/details', [ProjectController::class, 'getPoDetails']);
    Route::post('project/{id}/po/{po_id}/add-item', [ProjectController::class, 'addItemsPo']);
    Route::get('project/{id}/sub-contract-quotes', [ProjectController::class, 'getSubContracts']);
    
    Route::get('settings/suppliers', [ProjectController::class, 'getSuppliers']);
    
    Route::get('hr/users', [HrController::class, 'getUsers']);
    Route::get('hr/user/{id}/attendance', [HrController::class, 'getAttendance']);
    Route::post('hr/user/{id}/request-leave', [HrController::class, 'requestLeave']);
    Route::get('hr/user/{id}/contract-of-employment', [HrController::class, 'getContract']);
    Route::get('hr/user/{id}/documents', [HrController::class, 'getDocuments']);
    Route::get('hr/handbook', [HrController::class, 'getHandbook']);
    
    
});



