<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ShowController;
use App\Http\Controllers\DancerController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\DressingController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\VolunteerController;
use App\Models\Student;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('studio/login',[LoginController::class, 'studentLogin'])->name('studentLogin');
Route::post('studio/forgot-password',[LoginController::class, 'forgotPassword'])->name('forgotPassword');



Route::group( ['prefix' => 'studio', 'middleware' => ['auth:student-api','scopes:student'] ],function(){
    
    
    
    //Shows Endpoints
    Route::get('shows', [ShowController::class, 'getShows']);
    Route::get('show-dancers', [ShowController::class, 'showDancers']);
    Route::get('show-groups', [ShowController::class, 'showGroups']);
    Route::get('show-details', [ShowController::class, 'showDetails']);
    Route::post('add-new-show', [ShowController::class, 'addNewShow']);
    Route::post('show/assign-dancer', [ShowController::class, 'assignDancer']);
    Route::post('show/assign-multiple-dancers', [ShowController::class, 'assignMultipleDancers']);
    
    
    //Dancers Endpoints
    Route::get('dancer-details', [DancerController::class, 'dancerDetails']);
    Route::get('dancers', [DancerController::class, 'getDancers']);
    Route::post('add-new-dancer', [DancerController::class, 'addNewDancer']);
    Route::post('dancer/show-dressing-rooms', [DancerController::class, 'getDancerShowDressingRooms']);
    Route::post('dancer/show-routines', [DancerController::class, 'getDancerShowRoutines']);
    Route::post('dancer/checkin', [DancerController::class, 'dancerCheckin']);
    Route::post('dancer/checkout', [DancerController::class, 'dancerCheckout']);
    
    
    //Volunteers Endpoints
    Route::post('volunteer/checkin', [VolunteerController::class, 'volunteerCheckin']);
    Route::post('volunteer/checkout', [VolunteerController::class, 'volunteerCheckout']);
    
    
    //Groups Endpoints
    Route::get('groups', [GroupController::class, 'getGroups']);
    Route::get('group-details', [GroupController::class, 'groupDetails']);
    Route::get('group-dancers', [GroupController::class, 'groupDancers']);
    Route::post('add-new-group', [GroupController::class, 'addNewGroup']);
    Route::post('group/assign-dancer', [GroupController::class, 'assignDancer']);
    Route::post('group/assign-multiple-dancers', [GroupController::class, 'assignMultipleDancers']);
    
    //Dressings Endpoints
    Route::get('dressing-rooms', [DressingController::class, 'getDressings']);
    Route::post('dressing/assign-dancer', [DressingController::class, 'assignDancer']);
    Route::post('add-new-dressing-room', [DressingController::class, 'addNewDressing']);
    Route::post('dressing/assign-multiple-dancers', [DressingController::class, 'assignMultipleDancers']);
    Route::get('dressing-room-details', [DressingController::class, 'dressingDetails']);


});   