<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\PlanningController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ViewController;
use App\Http\Controllers\HrController;
use App\Http\Controllers\AccountController;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

Auth::routes();

Route::post('/forgot-password', [HomeController::class, 'forgotPassword'])->name('forgot.password');
Route::post('/reset-password/{token}', [HomeController::class, 'resetPassword'])->name('reset.password');
Route::get('/password/recovery/{link}', [HomeController::class, 'showPasswordReset'])->name('password.reset');




Route::get('/sign-up', [ViewController::class, 'signUpView'])->name('user.signUpView');
Route::post('/sign-up', [ViewController::class, 'signUp'])->name('user.signUp');
Route::get('/setup-profile', [ViewController::class, 'setupProfileView'])->name('user.setupProfileView');
Route::post('/setup-profile', [ViewController::class, 'setupProfile'])->name('user.setupProfile');
Route::get('/select-package', [ViewController::class, 'selectPackage'])->name('user.selectPackage');
Route::get('/content/create-post', [ViewController::class, 'createPostView'])->name('content.createPostView');

Route::get('/content/all-posts', [ViewController::class, 'allPosts'])->name('content.allPosts');

Route::post('/content/create-post', [ViewController::class, 'createPost'])->name('content.createPost');
Route::post('user/add-new-social', [ViewController::class, 'addNewSocial'])->name('user.addNewSocial');


Route::middleware(['auth', 'profile.complete'])->group(function () {
    
    Route::get('/reports/gross-profit-margin', [ReportController::class, 'showSalesReport'])->name('reports.showGrossProfitMarginReport');
    
    Route::get('/reports/work-in-progress', [ReportController::class, 'showSalesInvoiceReport'])->name('reports.showWipReport');
    
    Route::get('/reports/project-completion-rate', [ReportController::class, 'showCompletionRate'])->name('reports.showCompletionRate');
    
    Route::get('/reports/job-duration', [ReportController::class, 'showJobDuration'])->name('reports.showJobDuration');
    
    
    Route::get('/reports/cost-variance', [ReportController::class, 'showCostVariance'])->name('reports.showCostVariance');
    
    Route::get('/reports/bid-to-win', [ReportController::class, 'showBidToWin'])->name('reports.showBidToWin');
    
    
    Route::get('/reports/best-clients', [ReportController::class, 'showBestClients'])->name('reports.showBestClients');
    
    Route::get('/reports/contract-managers-reports', [ReportController::class, 'showContractManagersReport'])->name('reports.showContractManagersReport');
    
    Route::get('/reports/site-managers-reports', [ReportController::class, 'showSiteManagersReport'])->name('reports.showSiteManagersReport');
    
    Route::get('/reports/order-book-value', [ReportController::class, 'showOrderBookReport'])->name('reports.showOrderBookReport');
    
    Route::get('/reports/purchase-order-report', [ReportController::class, 'showPoReport'])->name('reports.showPoReport');
    
    
    
    
    Route::get('/hr/dashboard', [HrController::class, 'showDashboard'])->name('hr.showDashboard');
    Route::post('/hr/dashboard/upload-handbook', [HrController::class, 'uploadHandbook'])->name('hr.uploadHandbook');
    
    Route::post('/hr/user{id}/upload-contract', [HrController::class, 'uploadContract'])->name('hr.uploadContract');
    
    Route::get('/hr/user/{id}/personal-info', [HrController::class, 'showUserDetails'])->name('hr.userDetails');
    Route::get('/hr/user/{id}/edit-personal-info', [HrController::class, 'editUser'])->name('hr.editUser');
    Route::post('/hr/user/{id}/update', [HrController::class, 'updateUser'])->name('hr.updateUser');
    
    Route::get('/hr/user/{id}/asset-register', [HrController::class, 'showAssetRegister'])->name('hr.showAssetRegister');
    
    Route::post('/hr/user/{id}/update/holidays', [HrController::class, 'updateHolidays'])->name('hr.updateHolidays');
    
    Route::get('/hr/user/{id}/professional-info', [HrController::class, 'showProfessionalDetails'])->name('hr.professionalDetails');
    Route::get('/hr/user/{id}/edit-professional-info', [HrController::class, 'editProfessionalInfo'])->name('hr.editProfessionalInfo');
    Route::post('/hr/user/{id}/update-professional-info', [HrController::class, 'updateProfessionalInfo'])->name('hr.updateProfessionalInfo');
    
    Route::get('/holidays', [HrController::class, 'showHolidays'])->name('hr.showHolidays');
    
    Route::get('/hr/user/{id}/documents', [HrController::class, 'showDocuments'])->name('hr.showDocuments');
    Route::get('/hr/user/{id}/ppe-register', [HrController::class, 'showPPE'])->name('hr.showPPE');
    
    Route::post('/hr/user/{id}/document/add', [HrController::class, 'addDocument'])->name('hr.addDocument');
    Route::post('/hr/user/{id}/asset/add', [HrController::class, 'addAsset'])->name('hr.addAsset');
    Route::post('/hr/user/{id}/holiday/add', [HrController::class, 'addHoliday'])->name('hr.addHoliday');
    Route::post('/hr/user/{id}/sick-leave/add', [HrController::class, 'addSickLeave'])->name('hr.addSickLeave');
    Route::post('/hr/user/{id}/document/add-staff', [HrController::class, 'addDocumentStaff'])->name('hr.addDocumentStaff');
    Route::post('/hr/user/{id}/document/enable-notify', [HrController::class, 'enableNotify'])->name('hr.enableNotify');
    Route::post('/hr/user/{id}/asset/enable-notify', [HrController::class, 'enableAssetNotify'])->name('hr.enableAssetNotify');
    
    Route::post('/hr/user/{id}/workwear/update', [HrController::class, 'updateWorkwear'])->name('hr.updateWorkwear');
    
    Route::post('/hr/user/{id}/ppe/update', [HrController::class, 'updatePPE'])->name('hr.updatePPE');
    
    Route::post('/hr/user/{id}/workwear/add', [HrController::class, 'addWorkwear'])->name('hr.addWorkwear');
    Route::post('/hr/user/{id}/ppe/add', [HrController::class, 'addPPE'])->name('hr.addPPE');
    
    Route::get('/hr/user/{id}/attendance', [HrController::class, 'showAttendance'])->name('hr.showAttendance');
    
    Route::get('/hr/user/{id}/contract', [HrController::class, 'showContract'])->name('hr.showContract');
    
    Route::post('/hr/user/{id}/holiday/change-status', [HrController::class, 'changeHolidayStatus'])->name('hr.changeHolidayStatus');
    
    
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/dashboard/unlike', [DashboardController::class, 'unlike'])->name('dashboard.unlike');
    Route::get('/home', function () {
        return redirect(route('dashboard'));
    });
    //Customer
    Route::get('/customers', [CustomerController::class, 'view'])->name('customer.view');
    Route::get('/customer/details/{id}', [CustomerController::class, 'details'])->name('customer.details');
    //Route::get('/customer/projects', [CustomerController::class, 'view'])->name('customer.projects');
    Route::get('/customer/add-new', [CustomerController::class, 'addNew'])->name('customer.addNew');
    Route::post('/customer/store', [CustomerController::class, 'store'])->name('customer.store');
    Route::post('/customer/update/{id}', [CustomerController::class, 'update'])->name('customer.update');
    Route::post('/customer/updateImage/{id}', [CustomerController::class, 'updateImage'])->name('customer.updateImage');
    Route::post('/customer/addContact/{id}', [CustomerController::class, 'addContact'])->name('customer.addContact');
    
    Route::post('/project/{id}/financials/update', [ProjectController::class, 'updateFinancial'])->name('projects.updateFinancial');
    
    Route::post('/project/{id}/add-quote-item', [ProjectController::class, 'addQuoteItem'])->name('projects.addQuoteItem');
    
    Route::post('/project/{id}/send-sub-contract-link', [ProjectController::class, 'sendSubContractAsLink'])->name('project.sendSubContractAsLink');
    
    
    Route::post('/project/{id}/add-variation-item', [ProjectController::class, 'addVariationItem'])->name('projects.addVariationItem');
    
    Route::post('/project/{id}/update-quote-item', [ProjectController::class, 'updateQuoteItem'])->name('projects.updateQuoteItem');
    
    Route::post('/project/{id}/accept-quote', [ProjectController::class, 'acceptQuote'])->name('projects.acceptQuote');
    
    Route::post('/project/{id}/financials/show-po-details', [ProjectController::class, 'showPoDetails'])->name('projects.showPoDetails');
    
    Route::post('/project/{id}/sub-contract/quote-item-details', [ProjectController::class, 'getQuoteItemDetails'])->name('projects.getQuoteItemDetails');
    
    Route::post('/settings/read-notifications', [SettingController::class, 'readNotifications'])->name('settings.readNotifications');
    
    Route::get('/customer/{id}/projects', [CustomerController::class, 'showProjects'])->name('customer.projects');
    
    Route::post('/customer/{id}/addNewProject', [CustomerController::class, 'addNewProject'])->name('customer.addNewProject');
    
    
    Route::post('/settings/delete/project-type', [SettingController::class, 'deleteProjectType'])->name('settings.deleteProjectType');
    Route::post('/settings/delete/office-location', [SettingController::class, 'deleteOfficeLocation'])->name('settings.deleteOfficeLocation');
    Route::post('/settings/delete/project-status', [SettingController::class, 'deleteProjectStatus'])->name('settings.deleteProjectStatus');
    Route::post('/settings/delete/project-milestones', [SettingController::class, 'deleteProjectMilestones'])->name('settings.deleteProjectMilestones');
    Route::post('/settings/delete/financial-items', [SettingController::class, 'deleteFinancialItems'])->name('settings.deleteFinancialItems');
    Route::post('/settings/delete/financial-uoms', [SettingController::class, 'deleteFinancialUoms'])->name('settings.deleteFinancialUoms');
    Route::post('/settings/delete/address-type', [SettingController::class, 'deleteAddressType'])->name('settings.deleteAddressType');
    
    
    //Project
    Route::get('/project/{id}', [ProjectController::class, 'showDetails'])->name('project.details');
    Route::post('/project/{id}/updateEndCustomer', [ProjectController::class, 'updateEndCustomer'])->name('project.updateEndCustomer');
    Route::post('/project/{id}/updateLocation', [ProjectController::class, 'updateLocation'])->name('project.updateLocation');
    Route::post('/project/{id}/assignManager', [ProjectController::class, 'assignManager'])->name('project.assignManager');
    
    
    Route::post('/project/email/get-body', [ProjectController::class, 'getEmailBody'])->name('project.getEmailBody');
    
    
    Route::post('/project/{id}/exportImages', [ProjectController::class, 'exportImages'])->name('project.exportImages');
    
    Route::post('/project/{id}/create-invoice', [ProjectController::class, 'createInvoice'])->name('project.createInvoice');
    
    Route::get('/planning', [PlanningController::class, 'showPlanning'])->name('planning.showPlanning');
    
    
    
    Route::post('/project/{id}/create-purchase-order', [ProjectController::class, 'createPurchaseOrder'])->name('project.createPurchaseOrder');
    
    Route::post('/project/delete-invoice', [ProjectController::class, 'deleteInvoice'])->name('project.deleteInvoice');
    
    Route::post('/project/send-invoice', [ProjectController::class, 'sendInvoice'])->name('project.sendInvoice');
    
    
    Route::post('/project/add-new', [ProjectController::class, 'addNewProject'])->name('project.addNewProject');
    Route::post('/project/add-to-favourites', [ProjectController::class, 'addToFavourites'])->name('project.addToFavourites');
    
    
    Route::post('/project/document/add-to-favourites', [ProjectController::class, 'bookmarkDocument'])->name('project.bookmarkDocument');
    
    Route::post('/project/{id}/updateCustomer', [ProjectController::class, 'updateCustomer'])->name('project.updateCustomer');
    
    Route::post('/project/{id}/get-rams-pdf', [ProjectController::class, 'ramsPDF'])->name('projects.ramsPDF');
    
    Route::post('/project/{id}/update-rams', [ProjectController::class, 'updateRams'])->name('projects.updateRams');
    
    Route::post('/project/{id}/create-rams-document', [ProjectController::class, 'createRamsDocument'])->name('projects.createRamsDocument');
    
    Route::get('/project/{id}/images/before', [ProjectController::class, 'showBeforeImages'])->name('project.showBeforeImages');
    
    Route::get('/project/{id}/images/1st-site-visit', [ProjectController::class, 'showFirstSiteImages'])->name('project.showFirstSiteImages');
    
    Route::get('/accounts/transfer-purchase', [AccountController::class, 'showTransferPurchase'])->name('accounts.showTransferPurchase');
    
    
    Route::get('/accounts/transfer-sales', [AccountController::class, 'showTransferSales'])->name('accounts.showTransferSales');
    
    
    Route::get('/project/{id}/images/during', [ProjectController::class, 'showDuringImages'])->name('project.showDuringImages');
    
    
    Route::get('/project/{id}/images/during', [ProjectController::class, 'showDuringImages'])->name('project.showDuringImages');
    
    
    Route::get('/project/invoice/{id}', [ProjectController::class, 'viewInvoice'])->name('project.viewInvoice');
    
    Route::get('/project/{projectid}/variation/{id}', [ProjectController::class, 'viewVariation'])->name('project.viewVariation');
    
    
    
    Route::post('/project/{id}/status/update', [ProjectController::class, 'updateStatus'])->name('project.updateStatus');
    
    Route::post('/accounts/transfer-purchase', [AccountController::class, 'transferPurchase'])->name('accounts.transferPurchase');
    
    
    Route::post('/accounts/transfer-sales', [AccountController::class, 'transferSales'])->name('accounts.transferSales');
    
    
    Route::post('/project/{id}/send-variation', [ProjectController::class, 'sendVariation'])->name('projects.sendVariation');
    
    Route::get('/project/{id}/images/project-completed', [ProjectController::class, 'showCompletedImages'])->name('project.showCompletedImages');
    
    Route::post('/project/documents/save-notes', [ProjectController::class, 'saveDocumentNotes'])->name('project.documents.saveNote');
    
    Route::post('/project/update/milestone-notes', [ProjectController::class, 'updateMilestoneNotes'])->name('project.updateMilestoneNotes');
    Route::post('/project/delete/document', [ProjectController::class, 'deleteDocument'])->name('project.deleteDocument');
    
    
    Route::post('/project/delete/image', [ProjectController::class, 'deleteImage'])->name('project.deleteImage');
    Route::post('/project/update/image', [ProjectController::class, 'updateImage'])->name('project.updateImage');
    
    
    Route::post('/project/update/document-notes', [ProjectController::class, 'updateDocumentNotes'])->name('project.updateDocumentNotes');
    
    Route::post('/project/import-excel', [ProjectController::class, 'importExcel'])->name('project.importExcel');
    
    Route::post('/project/update/document-access', [ProjectController::class, 'updateDocumentAccess'])->name('project.updateDocumentAccess');
    
    Route::post('/planning/add-planning', [PlanningController::class, 'addPlanning'])->name('planning.addPlanning');
    
    Route::post('/planning/approve-planning', [PlanningController::class, 'approvePlanning'])->name('planning.approvePlanning');
    
    Route::post('/planning/swap-projects', [PlanningController::class, 'swapProjects'])->name('planning.swapProjects');
    
    Route::post('/planning/confirm-planning', [PlanningController::class, 'confirmPlanning'])->name('planning.confirmPlanning');
    
    Route::post('/planning/revoke-confirmation', [PlanningController::class, 'revokeConfirmation'])->name('planning.revokeConfirmation');
    
    Route::post('/planning/update-date-range', [PlanningController::class, 'updateDateRange'])->name('planning.updateDateRange');
    
    Route::post('/planning/check-users', [PlanningController::class, 'checkExistingUsers'])->name('planning.checkExistingUsers');
    
    Route::post('/planning/save-note', [PlanningController::class, 'saveNote'])->name('planning.saveNote');
    Route::post('/planning/details', [PlanningController::class, 'getPlanningDetails'])->name('planning.getPlanningDetails');
    Route::post('/planning/remove-from-project', [PlanningController::class, 'removeFromProject'])->name('planning.removeFromProject');
    Route::post('/planning/remove-project', [PlanningController::class, 'removeProject'])->name('planning.removeProject');
    Route::post('/planning/time-sheet/add-time-data', [PlanningController::class, 'addTimeData'])->name('planning.addTimeData');
    
    Route::post('/planning/time-sheet/add-user-timesheet', [PlanningController::class, 'addUserTimesheet'])->name('planning.addUserTimesheet');
    
    Route::post('/planning/update-color', [PlanningController::class, 'updateColor'])->name('planning.updateColor');
    
    Route::get('/planning/time-sheet', [PlanningController::class, 'showTimeSheet'])->name('planning.showTimeSheet');
    
    
    Route::get('/settings/project-types', [SettingController::class, 'viewProjectTypes'])->name('settings.projectTypes');
    Route::get('/settings/project-statuses', [SettingController::class, 'viewProjectStatuses'])->name('settings.projectStatuses');
    Route::get('/settings/address-types', [SettingController::class, 'viewAddressTypes'])->name('settings.addressTypes');
    Route::get('/settings/milestones', [SettingController::class, 'viewMilestones'])->name('settings.milestones');
    Route::get('/settings/users', [SettingController::class, 'viewUsers'])->name('settings.users');
    
    Route::get('/settings/profile', [SettingController::class, 'viewProfile'])->name('settings.profile');
    Route::post('/update-password', [SettingController::class, 'updatePassword'])->name('update.password');
    Route::post('/update-profile', [SettingController::class, 'updateProfile'])->name('update.profile');
    
    

    
    Route::get('/settings/financial-items', [SettingController::class, 'viewFinancialItems'])->name('settings.financialItems');
    
    Route::post('/settings/addFinancialItem', [SettingController::class, 'addFinancialItem'])->name('settings.addFinancialItem');
    
    Route::post('/settings/addFinancialUom', [SettingController::class, 'addFinancialUom'])->name('settings.addFinancialUom');
    
    Route::post('/settings/updateFinancialUom', [SettingController::class, 'updateFinancialUom'])->name('settings.updateFinancialUom');
    
    Route::post('/settings/updateAddressType', [SettingController::class, 'updateAddressType'])->name('settings.updateAddressType');
    
    Route::get('/settings/financial-uoms', [SettingController::class, 'viewFinancialUoms'])->name('settings.financialUoms');
    
    Route::get('/settings/office-locations', [SettingController::class, 'officeLocations'])->name('settings.officeLocations');
    
    
    Route::post('/project/{id}/addFinancials', [ProjectController::class, 'addFinancials'])->name('project.addFinancials');
    
    Route::get('/project/{id}/edit-spreadsheet', [ProjectController::class, 'editSpreadSheet'])->name('project.editSpreadSheet');
    
    Route::post('/project/{id}/importFinancials', [ProjectController::class, 'importFinancials'])->name('project.importFinancials');
    
    Route::post('/project/{id}/upliftFinancials', [ProjectController::class, 'upliftFinancials'])->name('project.upliftFinancials');
    
    
    Route::post('/project/{id}/addVariation', [ProjectController::class, 'addVariation'])->name('projects.addVariation');
    
    Route::post('/project/delete', [ProjectController::class, 'deleteProject'])->name('projects.deleteProject');
    Route::post('/hr/delete/asset', [HrController::class, 'deleteAsset'])->name('settings.deleteAsset');
    
    Route::post('/project/delete/financial-item', [ProjectController::class, 'deleteFinancialItem'])->name('project.deleteFinancialItem');
    
    Route::post('/project/getItemsDetails', [ProjectController::class, 'getItemsDetails'])->name('project.getItemsDetails');
    
    Route::get('/projects', [ProjectController::class, 'viewProjects'])->name('projects.view');
    Route::get('/project/{id}/milestones', [ProjectController::class, 'showMilestones'])->name('projects.milestones');
    
    Route::get('/project/{id}/financials', [ProjectController::class, 'showFinancials'])->name('projects.financials');
    
    Route::post('/project/delete/tender-item', [ProjectController::class, 'deleteTenderItem'])->name('project.deleteTenderItem');
    
    Route::post('/project/update/tender-items', [ProjectController::class, 'updateTenderItems'])->name('project.updateTenderItems');
    
    Route::get('/project/{id}/edit-tender-financials', [ProjectController::class, 'editTenderFinancials'])->name('projects.editTenderFinancials');
    
    Route::get('/project/{id}/sub-contracts-quote', [ProjectController::class, 'showSubContractsQuote'])->name('projects.subContractsQuote');
    
    
    Route::get('/project/{id}/variations', [ProjectController::class, 'showVariations'])->name('projects.showVariations');
    
    
    Route::get('/get-supplier-contacts', [ProjectController::class, 'getSupplierContacts'])->name('projects.getSupplierContacts');
    
    
    Route::get('/project/{id}/documents', [ProjectController::class, 'showDocuments'])->name('projects.documents');
    
    Route::get('/project/{id}/images', [ProjectController::class, 'showImages'])->name('projects.images');
    
    Route::get('/project/{id}/correspondence', [ProjectController::class, 'showCorrespondence'])->name('projects.correspondence');
    Route::get('/project/{id}/emails', [ProjectController::class, 'showEmails'])->name('project.emails');
    
    Route::get('/settings/project-types/{id}/milestones', [SettingController::class, 'showProjectTypeMilestones'])->name('settings.pt.milestones');
    
    Route::post('/project/{id}/addMilestone', [ProjectController::class, 'addMilestone'])->name('project.addMilestone');
    Route::post('/project/completeMilestone', [ProjectController::class, 'completeMilestone'])->name('project.completeMilestone');
    
    Route::post('/project/{id}/addMoreSuppliers', [ProjectController::class, 'addMoreSuppliers'])->name('project.addMoreSuppliers');
    
    Route::post('/project/{id}/addSubContractQuotes', [ProjectController::class, 'addSubContractQuotes'])->name('project.addSubContractQuotes');
    
    Route::post('/project/{id}/uploadDocument', [ProjectController::class, 'uploadDocument'])->name('project.uploadDocument');
    
    Route::post('/project/{id}/uploadProjectImages', [ProjectController::class, 'uploadProjectImages'])->name('project.uploadProjectImages');
    
    Route::post('/project/{id}/uploadSubContractDocuments', [ProjectController::class, 'uploadSubContractDocuments'])->name('project.uploadSubContractDocuments');
    
    Route::post('/project/{id}/uploadImage', [ProjectController::class, 'uploadImage'])->name('project.uploadImage');
    
    Route::post('/purchase-order/{id}/update', [AccountController::class, 'updatePurchaseOrder'])->name('accounts.updatePurchaseOrder');
    
    Route::post('/accounts/get-sub-contracts', [AccountController::class, 'getSubContracts'])->name('accounts.getSubContracts');
    
    Route::post('/accounts/add-invoice-po/{id}', [AccountController::class, 'addInvoicePO'])->name('accounts.addInvoicePO');
    
    Route::post('/accounts/pass-supplier-invoice/{id}', [AccountController::class, 'passSupplierInvoice'])->name('accounts.passSupplierInvoice');
    
    
    Route::post('/settings/add-project-type', [SettingController::class, 'addProjectType'])->name('settings.addProjectType');
    Route::post('/settings/add-office-location', [SettingController::class, 'addOfficeLocation'])->name('settings.addOfficeLocation');
    Route::post('/settings/update-project-type', [SettingController::class, 'updateProjectType'])->name('settings.updateProjectType');
    Route::post('/settings/update-project-milestone', [SettingController::class, 'updateMilestone'])->name('settings.updateMilestone');
    Route::post('/settings/update-financials', [SettingController::class, 'updateFinancials'])->name('settings.updateFinancials');
    
    Route::post('/settings/update-milestone-sort', [SettingController::class, 'updateMilestoneSort'])->name('settings.updateMilestoneSort');
    Route::post('/settings/update-project-status', [SettingController::class, 'updateProjectStatus'])->name('settings.updateProjectStatus');
    Route::post('/settings/update-office-location', [SettingController::class, 'updateOfficeLocation'])->name('settings.updateOfficeLocation');
    Route::post('/settings/add-address-type', [SettingController::class, 'addAddressType'])->name('settings.addAddressType');
    Route::post('/settings/add-project-status', [SettingController::class, 'addProjectStatus'])->name('settings.addProjectStatus');
    Route::post('/settings/add-milestone', [SettingController::class, 'addMilestone'])->name('settings.addMilestone');
    Route::post('/settings/add-staff', [SettingController::class, 'addStaff'])->name('settings.addStaff');
    
    Route::get('/settings/edit/user/{id}', [SettingController::class, 'editUser'])->name('settings.editUser');
    Route::post('/settings/user/{id}/update', [SettingController::class, 'updateUser'])->name('settings.updateUser');
    
    Route::post('/project/{id}/add-correspondence', [ProjectController::class, 'addCorrespondence'])->name('project.addCorrespondence');
    
    Route::post('/project/add-supplier-contact', [ProjectController::class, 'addSupplierContact'])->name('project.addSupplierContact');
    
    Route::post('/project/{id}/update-project', [ProjectController::class, 'updateProject'])->name('project.updateProject');
    
    
    Route::get('/accounts/purchase-order', [AccountController::class, 'purchaseOrder'])->name('accounts.purchaseOrder');
    Route::post('/accounts/create-purchase-order', [AccountController::class, 'createPurchaseOrder'])->name('accounts.createPurchaseOrder');
    Route::get('/accounts/purchase-order/{id}/details', [AccountController::class, 'purchaseOrderDetails'])->name('accounts.purchaseOrderDetails');
    Route::post('/accounts/add-items-po/{id}', [AccountController::class, 'addItemsPO'])->name('accounts.addItemsPO');
    
    Route::post('/accounts/delete-po-item/{po_id}', [AccountController::class, 'deletePoItem'])->name('accounts.deletePoItem');
    
    Route::post('/accounts/delete-po', [AccountController::class, 'deletePO'])->name('accounts.deletePO');
    
    Route::get('/accounts/purchase-order-list', [AccountController::class, 'purchaseOrderList'])->name('accounts.purchaseOrderList');
    
    Route::post('/accounts/send-po', [AccountController::class, 'sendPO'])->name('accounts.sendPO');
    
    Route::post('/accounts/print/purchase-order/{id}', [AccountController::class, 'printPO'])->name('accounts.printPO');
    
    Route::get('/accounts/sub-contracts-list', [AccountController::class, 'subContractsList'])->name('accounts.subContractsList');
    
    Route::get('/accounts/supplier-invoice', [AccountController::class, 'supplierInvoices'])->name('accounts.supplierInvoices');
    
    Route::get('/accounts/supplier-invoices-list', [AccountController::class, 'supplierInvoicesList'])->name('accounts.supplierInvoicesList');
    
    Route::get('/accounts/supplier-invoice/{id}', [AccountController::class, 'supplierInvoiceDetails'])->name('accounts.supplierInvoiceDetails');
    
    
    Route::post('/accounts/get-po-items', [AccountController::class, 'getPoItems'])->name('accounts.getPoItems');
    
    Route::post('/accounts/get-purchase-orders', [AccountController::class, 'getPurchaseOrders'])->name('accounts.getPurchaseOrders');
    Route::post('/accounts/create-supplier-invoice', [AccountController::class, 'createSupplierInvoice'])->name('accounts.createSupplierInvoice');
    
    
    Route::post('/settings/upload-user-image/{id}', [SettingController::class, 'uploadUserImage'])->name('settings.uploadUserImage');
    
    Route::get('/test/emails', [ProjectController::class, 'getEmails'])->name('project.getEmails');
    
});










