<!DOCTYPE html>
<html lang="en">

<head>
    <title>Sign-up</title>
    <meta charset="utf-8" />

    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta property="og:locale" content="en_US" />
    <link rel="shortcut icon" href="<?php echo e(asset('media/logos/favicon.ico')); ?>" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
    <link href="<?php echo e(asset('plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('css/custom.css')); ?>?<?php echo e(time()); ?>" rel="stylesheet" type="text/css" />

</head>
<!--end::Head-->
<!--begin::Body-->

<body id="kt_body" class="app-blank bgi-size-cover bgi-attachment-fixed bgi-position-center bgi-no-repeat">
    <!--begin::Theme mode setup on page load-->
    <script>
        var defaultThemeMode = "light";
        var themeMode;
        if (document.documentElement) {
            if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
                themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
            } else {
                if (localStorage.getItem("data-bs-theme") !== null) {
                    themeMode = localStorage.getItem("data-bs-theme");
                } else {
                    themeMode = defaultThemeMode;
                }
            }
            if (themeMode === "system") {
                themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
            }
            document.documentElement.setAttribute("data-bs-theme", themeMode);
        }

    </script>
    <!--end::Theme mode setup on page load-->
    <!--begin::Root-->
    <div class="d-flex flex-column flex-root" id="kt_app_root">
        <!--begin::Page bg image-->
        <style>
            .form-label {
                color: #666666;
            }

            .bg-body {
                border: 1px solid #ddd;
            }
            
            .btn-primary{
                color: white !important;
            }

        </style>
        <!--end::Page bg image-->
        <!--begin::Authentication - Sign-in -->
        <div class="d-flex flex-column flex-column-fluid justify-content-center">
            <!--begin::Aside-->

            <!--begin::Aside-->
            <!--begin::Body-->
            <div class="d-flex flex-column-fluid flex-lg-row-auto justify-content-center  p-12 p-lg-20">
                <!--begin::Card-->
                <div class="bg-body  d-flex flex-column align-items-stretch flex-center rounded-4 w-md-600px p-10">
                    <!--begin::Wrapper-->
                    <div class=" px-lg-10">
                        <div class="row">
                            <div class="col-md-12">
                                <?php if(session('danger')): ?>
                        <div class="alert alert-danger">
                            <?php echo e(session('danger')); ?>

                        </div>
                        <?php endif; ?>

                        <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <?php echo implode('<br>', $errors->all(':message')); ?>

                        </div>
                        <?php endif; ?>
                            </div>
                        </div>
                        <form class="form w-100" method="POST" action="<?php echo e(route('user.signUp')); ?>" id="loginForm">
                            <!--begin::Heading-->
                            <div class="text-center mb-11">
                                <!--begin::Title-->
                                <h1 style="color:#333333" class="mb-8">Create an account</h1>

                            </div>

                            <div class="fv-row mb-8">
                                <label for="" class="form-label">Email</label>
                                <input type="text" placeholder="Email" name="email" autocomplete="off" class="form-control bg-transparent" required value="<?php echo e(old('email')); ?>" />
                                <!--end::Email-->
                            </div>
                            <!--end::Input group=-->
                            <div class="fv-row mb-8">
                                <!--begin::Password-->
                                <label for="" class="form-label">Password</label>
                                <input type="password" placeholder="Password" name="password" autocomplete="off" class="form-control bg-transparent" required />
                                <!--end::Password-->
                            </div>
                            <div class="fv-row mb-8">
                                <!--begin::Password-->
                                <label for="" class="form-label">Confirm Password</label>
                                <input type="password" placeholder="Confirm Password" name="password_confirmation" autocomplete="off" class="form-control bg-transparent" required />
                                <!--end::Password-->
                            </div>

                            <!--end::Wrapper-->
                            <!--begin::Submit button-->



                            <div class="d-grid mb-8">
                                <?php echo csrf_field(); ?>
                                <button type="submit" name="submit" id="kt_sign_in_submit" class="btn btn-gradient">
                                    <!--begin::Indicator label-->
                                    <span class="indicator-label">Sign Up</span>
                                    <!--end::Indicator label-->
                                    <!--begin::Indicator progress-->
                                    <span class="indicator-progress">Please wait...
                                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                    <!--end::Indicator progress-->
                                </button>

                            </div>
                            <div class="text-center">
                                By creating an account, you agree to the <u>Terms of use</u> and <u>Privacy Policy</u>.
                            </div>

                        </form>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="separator separator-content my-14">
                                <span class=" fw-bold" style="font-size:20px;color:#666666">OR</span>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <a href="#" class="btn btn-flex btn-outline btn-text-gray-700 btn-active-color-primary bg-state-light flex-center text-nowrap w-100">
											<img alt="Logo" src="<?php echo e(asset('media/svg/brand-logos/google-icon.svg')); ?>" class="h-15px me-3">Continue with Google</a>
                        </div>
                        <div class="col-12 mb-8">
                            <a href="#" class="btn btn-flex btn-outline btn-text-gray-700 btn-active-color-primary bg-state-light flex-center text-nowrap w-100">
											<img alt="Logo" src="<?php echo e(asset('media/svg/brand-logos/apple-black.svg')); ?>" class="theme-light-show h-15px me-3">
											<img alt="Logo" src="<?php echo e(asset('media/svg/brand-logos/apple-black-dark.svg')); ?>" class="theme-dark-show h-15px me-3">Sign in with Apple</a>
                        </div>
                        <div class="col-12">
                            <div class="text-center">
                                Already have an account? <a href="<?php echo e(route('login')); ?>">Login</a>
                            </div>
                        </div>
                    </div>

                </div>
                <!--end::Card-->
            </div>
            <!--end::Body-->
        </div>
        <!--end::Authentication - Sign-in-->
    </div>
    <!--end::Root-->
    <!--begin::Javascript-->
    <script>
        var hostUrl = "assets/";

    </script>
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <script src="assets/plugins/global/plugins.bundle.js"></script>
    <script src="assets/js/scripts.bundle.js"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Custom Javascript(used for this page only)-->
    <script src="assets/js/custom/authentication/sign-in/general.js"></script>
    <script src="<?php echo e(asset('plugins/global/plugins.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('js/scripts.bundle.js')); ?>"></script>
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
    <script>
        $("#showReset").click(function() {
            $("#loginForm").hide();
            $("#passwordResetForm").show();
        });

        $("#showLogin").click(function() {
            $("#passwordResetForm").hide();
            $("#loginForm").show();
        });

    </script>
</body>
<!--end::Body-->

</html>
<?php /**PATH C:\xampp\htdocs\boom_social\resources\views/auth/signup.blade.php ENDPATH**/ ?>